/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.torqlang.util.AdjoinedSourceSpan;
import org.torqlang.util.EmptySourceSpan;
import org.torqlang.util.LineAndChar;
import org.torqlang.util.SourceString;
import org.torqlang.util.StringTools;

public interface SourceSpan {
    public static SourceSpan adjoin(Collection<? extends SourceSpan> sourceSpans) {
        Iterator<? extends SourceSpan> iter = sourceSpans.iterator();
        SourceSpan answer = iter.next();
        while (iter.hasNext()) {
            answer = answer.adjoin(iter.next());
        }
        return answer;
    }

    public static SourceSpan emptySourceSpan() {
        return EmptySourceSpan.EMPTY_SOURCE_SPAN;
    }

    private static boolean showLine(int i, int lineIndex, int showBefore, int showAfter) {
        return i == lineIndex || i < lineIndex && lineIndex - i <= showBefore || i > lineIndex && i - lineIndex <= showAfter;
    }

    public static LineAndChar toLineAndChar(SourceSpan sourceSpan, int baseLineNr, int baseCharNr) {
        int lineNr = baseLineNr;
        int charNr = baseCharNr;
        for (int i = 0; sourceSpan.source().containsIndex(i) && i < sourceSpan.sourceBegin(); ++i) {
            char c = sourceSpan.source().charAt(i);
            if (c == '\n') {
                ++lineNr;
                charNr = baseCharNr;
                continue;
            }
            ++charNr;
        }
        return new LineAndChar(lineNr, charNr);
    }

    default public SourceSpan adjoin(SourceSpan other) {
        return new AdjoinedSourceSpan(this, other);
    }

    default public String formatSource(String message, int lineNrWidth, int showBefore, int showAfter) {
        String sourceAsString = this.source().content();
        LineAndChar location = SourceSpan.toLineAndChar(this, 0, 0);
        StringBuilder answerBuf = new StringBuilder();
        int lineIndex = location.lineNr;
        List<String> sourceLines = StringTools.toSourceLines(sourceAsString, 1, lineNrWidth);
        boolean lineAppended = false;
        for (int i = 0; i < sourceLines.size(); ++i) {
            String line = sourceLines.get(i);
            if (SourceSpan.showLine(i, lineIndex, showBefore, showAfter)) {
                if (lineAppended) {
                    answerBuf.append('\n');
                }
                answerBuf.append(line);
                lineAppended = true;
            }
            if (i != lineIndex) continue;
            if (lineAppended) {
                answerBuf.append('\n');
            }
            StringBuilder indentBuf = new StringBuilder();
            int indentLength = lineNrWidth + 1 + location.charNr;
            while (indentBuf.length() < indentLength) {
                indentBuf.insert(0, " ");
            }
            answerBuf.append((CharSequence)indentBuf);
            answerBuf.append("^__ ");
            answerBuf.append(message != null ? message : "Error");
            lineAppended = true;
        }
        return answerBuf.toString();
    }

    public SourceString source();

    public int sourceBegin();

    public int sourceEnd();

    public SourceSpan toSourceBegin();

    public SourceSpan toSourceEnd();
}

