/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.aspects.logging;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class LoggerAspect {
    private static final ILoggerFactory FACTORY = LoggerFactory.getILoggerFactory();

    @Around(value="@annotation(org.treetank.aspects.logging.Logging)")
    public Object advice(ProceedingJoinPoint pjp) throws Throwable {
        Signature sig = pjp.getSignature();
        Logger logger = FACTORY.getLogger(sig.getDeclaringTypeName());
        logger.debug("Entering " + sig.getDeclaringTypeName());
        Object returnVal = pjp.proceed();
        logger.debug("Exiting " + sig.getDeclaringTypeName());
        return returnVal;
    }
}

