/*
 * Decompiled with CFR 0.152.
 */
package org.jaxrx.blackbox;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jaxrx.JettyServer;
import org.jaxrx.resource.XMLResource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ClientBlackBoxTest {
    private transient XMLResource xmlResource;
    private final transient String SYSPROPERTY = System.getProperty("org.jaxrx.systemPath");
    private final transient String SYSTEMNAME = this.SYSPROPERTY == null ? "dom" : this.SYSPROPERTY;
    private final transient String RESURI = "factbookLite";
    private static final transient int PORT = 8091;
    private final transient String JAXRX = "jax-rx";
    private final transient String COUNTRY = "country";
    private final transient String RESULTNODE = "jaxrx:result";
    private final transient URL REQURL = new URL("http://localhost:8091/" + this.SYSTEMNAME + "/" + "jax-rx" + "/" + "factbookLite");
    private transient HttpURLConnection connection;

    @BeforeClass
    public static void globSetUp() throws Exception {
        new JettyServer(8091);
    }

    @Before
    public void setUp() throws Exception {
        this.xmlResource = new XMLResource();
        InputStream testXML = ClientBlackBoxTest.class.getResourceAsStream("/factbook.xml");
        this.xmlResource.putResource(this.SYSTEMNAME, "factbookLite", null, testXML);
        testXML.close();
    }

    @After
    public void tearDown() {
        this.xmlResource.deleteResource(this.SYSTEMNAME, "factbookLite", null);
    }

    @Test
    public void testGetRes() throws IOException, SAXException, ParserConfigurationException {
        this.connection = (HttpURLConnection)this.REQURL.openConnection();
        int code = this.connection.getResponseCode();
        if (code == 200) {
            Document doc = this.xmlDocument(this.connection.getInputStream());
            NodeList nodes = doc.getElementsByTagName("country");
            Assert.assertTrue((String)"Check if more than one result", (nodes.getLength() > 1 ? 1 : 0) != 0);
            nodes = doc.getElementsByTagName("jaxrx:result");
            Assert.assertTrue((String)"Check if result node is not in result: ", (nodes.getLength() == 0 ? 1 : 0) != 0);
        }
        Assert.assertEquals((String)"Test if get request has been performed successful", (long)200L, (long)code);
        URL overviewURL = new URL("http://localhost:8091/" + this.SYSTEMNAME + "/" + "jax-rx");
        this.connection = (HttpURLConnection)overviewURL.openConnection();
        code = this.connection.getResponseCode();
        if (code == 200) {
            Document document = this.xmlDocument(this.connection.getInputStream());
            NodeList nodes = document.getElementsByTagName("jax-rx:resource");
            Assert.assertEquals((String)"Test if 1 resource is available", (long)1L, (long)nodes.getLength());
        }
        Assert.assertEquals((String)"Test if the request has been successful", (long)200L, (long)code);
        this.connection.disconnect();
    }

    @Test
    public void testGetResParams() throws IOException, SAXException, ParserConfigurationException {
        Node resultNode;
        Attr attribute;
        NodeList results;
        Document doc;
        String query = "/descendant::country[attribute::name='Austria']";
        String wrap = "wrap=no";
        URL queryUrl = new URL(this.REQURL.toString() + "?query=" + "/descendant::country[attribute::name='Austria']" + "&" + wrap);
        this.connection = (HttpURLConnection)queryUrl.openConnection();
        int code = this.connection.getResponseCode();
        if (code == 200) {
            doc = this.xmlDocument(this.connection.getInputStream());
            results = doc.getElementsByTagName("country");
            Assert.assertEquals((String)"Test if only 1 country has been received: ", (long)1L, (long)results.getLength());
            attribute = (Attr)results.item(0).getAttributes().getNamedItem("name");
            Assert.assertEquals((String)"Test if expected country is Austria: ", (Object)"Austria", (Object)attribute.getTextContent());
            resultNode = doc.getElementsByTagName("jaxrx:result").item(0);
            Assert.assertNull((String)"Test if result node does not exists: ", (Object)resultNode);
        }
        this.connection.disconnect();
        Assert.assertEquals((String)"Test if get request has been performed successful", (long)200L, (long)code);
        wrap = "wrap=yes";
        queryUrl = new URL(this.REQURL.toString() + "?query=" + "/descendant::country[attribute::name='Austria']" + "&" + wrap);
        HttpURLConnection connection2 = (HttpURLConnection)queryUrl.openConnection();
        code = connection2.getResponseCode();
        if (code == 200) {
            doc = this.xmlDocument(connection2.getInputStream());
            results = doc.getElementsByTagName("country");
            Assert.assertEquals((String)"Test if only 1 country has been received again: ", (long)1L, (long)results.getLength());
            attribute = (Attr)results.item(0).getAttributes().getNamedItem("name");
            Assert.assertEquals((String)"Test if expected country is Austria again: ", (Object)"Austria", (Object)attribute.getTextContent());
            resultNode = doc.getElementsByTagName("jaxrx:result").item(0);
            Assert.assertNotNull((String)"Test if result node exists: ", (Object)resultNode);
        }
        connection2.disconnect();
        Assert.assertEquals((String)"Test if get request has been performed successful", (long)200L, (long)code);
    }

    @Test
    public void testPut() throws IOException {
        int read;
        String reqURL = "theNewResource";
        URL theURL = new URL("http://localhost:8091/" + this.SYSTEMNAME + "/" + "jax-rx" + "/" + "theNewResource");
        this.connection = (HttpURLConnection)theURL.openConnection();
        int code = this.connection.getResponseCode();
        Assert.assertEquals((String)"Test if the resource is exists before creation: ", (long)404L, (long)code);
        this.connection = (HttpURLConnection)theURL.openConnection();
        this.connection.setRequestMethod("PUT");
        this.connection.setDoOutput(true);
        BufferedOutputStream output = new BufferedOutputStream(this.connection.getOutputStream());
        BufferedInputStream input = new BufferedInputStream(ClientBlackBoxTest.class.getResourceAsStream("/factbook.xml"));
        while ((read = ((InputStream)input).read()) != -1) {
            ((OutputStream)output).write(read);
        }
        ((OutputStream)output).flush();
        ((OutputStream)output).close();
        ((InputStream)input).close();
        code = this.connection.getResponseCode();
        Assert.assertEquals((String)"Test if the resource has been successful created", (long)201L, (long)code);
        this.connection = (HttpURLConnection)theURL.openConnection();
        code = this.connection.getResponseCode();
        Assert.assertEquals((String)"Test if the resource is now available ", (long)200L, (long)code);
        InputStream is = this.connection.getInputStream();
        while (is.read() != -1) {
        }
        this.connection.disconnect();
    }

    @Test
    public void testPostQuery() throws IOException, SAXException, ParserConfigurationException {
        String postRequest = "<query xmlns:jax-rx='http://jax-rx.sourceforge.net'>\n  <text>//continent<![CDATA[[position()<3]]]></text>\n  <parameter name='wrap' value='yes'/>\n</query>";
        this.connection = (HttpURLConnection)this.REQURL.openConnection();
        this.connection.setDoOutput(true);
        this.connection.setRequestMethod("POST");
        this.connection.setRequestProperty("Content-Type", "application/query+xml");
        BufferedOutputStream output = new BufferedOutputStream(this.connection.getOutputStream());
        output.write("<query xmlns:jax-rx='http://jax-rx.sourceforge.net'>\n  <text>//continent<![CDATA[[position()<3]]]></text>\n  <parameter name='wrap' value='yes'/>\n</query>".getBytes("UTF-8"));
        output.flush();
        output.close();
        int code = this.connection.getResponseCode();
        InputStream input = this.connection.getInputStream();
        Document document = this.xmlDocument(input);
        NodeList nodes = document.getElementsByTagName("continent");
        Assert.assertEquals((String)"Test if query result is confirmed", (long)200L, (long)code);
        Assert.assertEquals((String)"Test if the expected continent nodes are correct", (long)2L, (long)nodes.getLength());
        input.close();
        this.connection.disconnect();
    }

    @Test
    public void testDeleteRes() throws Exception {
        this.connection = (HttpURLConnection)this.REQURL.openConnection();
        int code = this.connection.getResponseCode();
        Assert.assertEquals((String)"Test if the resource is existing: ", (long)200L, (long)code);
        this.connection = (HttpURLConnection)this.REQURL.openConnection();
        this.connection.setRequestMethod("DELETE");
        code = this.connection.getResponseCode();
        Assert.assertEquals((String)"Test if deleting has been successful", (long)200L, (long)code);
        this.connection = (HttpURLConnection)this.REQURL.openConnection();
        code = this.connection.getResponseCode();
        Assert.assertEquals((String)"Test if the resource is no longerexisting: ", (long)404L, (long)code);
        this.connection.disconnect();
    }

    private Document xmlDocument(InputStream input) throws SAXException, IOException, ParserConfigurationException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input);
    }
}

