/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.service.jaxrx.implementation;

import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jaxrx.core.JaxRxException;
import org.jaxrx.core.QueryParameter;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;
import org.treetank.exception.TTException;
import org.treetank.io.IBackend;
import org.treetank.revisioning.IRevisioning;
import org.treetank.service.jaxrx.implementation.DatabaseRepresentation;
import org.treetank.service.jaxrx.implementation.NodeIdRepresentation;
import org.treetank.service.jaxrx.util.DOMHelper;
import org.treetank.testutil.CoreTestHelper;
import org.treetank.testutil.ModuleFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Guice(moduleFactory=ModuleFactory.class)
public class DatabaseRepresentationTest {
    private static final transient String ASSTRUE = "check if true";
    private static final transient String ASSEQUALS = "check if equals";
    private static transient DatabaseRepresentation treetank;
    private static final transient String XMLFILE = "/factbook.xml";
    private static final transient String LITERALTRUE = "yes";
    private static final transient String RESULTNAME = "jaxrx:result";
    private static final transient String IDNAME = "rest:ttid";
    private static final transient String NAME = "name";
    @Inject
    public IBackend.IBackendFactory mStorageFac;
    @Inject
    public IRevisioning mRevisioning;

    @BeforeMethod
    public void setUp() throws TTException {
        CoreTestHelper.deleteEverything();
        InputStream input = DatabaseRepresentationTest.class.getResourceAsStream(XMLFILE);
        treetank = new DatabaseRepresentation(CoreTestHelper.getStorage((File)CoreTestHelper.PATHS.PATH1.getFile()), this.mStorageFac, this.mRevisioning);
        treetank.shred(input, "grave928134589762");
    }

    @AfterMethod
    public void tearDown() throws TTException {
        CoreTestHelper.deleteEverything();
    }

    @Test
    public void createResource() {
        InputStream input = DatabaseRepresentationTest.class.getResourceAsStream(XMLFILE);
        treetank.createResource(input, "grave928134589762");
        AssertJUnit.assertNotNull((String)"check if resource has been created", (Object)treetank.getResource("grave928134589762", null));
    }

    @Test(expectedExceptions={JaxRxException.class})
    public void createResourceExc() {
        treetank.createResource(null, "grave928134589762");
    }

    @Test
    public void getResource() throws TTException, WebApplicationException, IOException, ParserConfigurationException, SAXException {
        HashMap<QueryParameter, String> queryParams = new HashMap<QueryParameter, String>();
        StreamingOutput sOutput = treetank.getResource("grave928134589762", queryParams);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        sOutput.write((OutputStream)output);
        Document doc = DOMHelper.buildDocument(output);
        Node node = doc.getElementsByTagName("mondial").item(0);
        Attr attribute = (Attr)node.getAttributes().getNamedItem(IDNAME);
        Node resultNode = doc.getElementsByTagName(RESULTNAME).item(0);
        AssertJUnit.assertNotNull((String)"mondial does exist", (Object)node);
        AssertJUnit.assertNull((String)"test if result node exists - null", (Object)resultNode);
        AssertJUnit.assertNull((String)"test if id element exists - null", (Object)attribute);
        output.close();
        queryParams.put(QueryParameter.WRAP, LITERALTRUE);
        sOutput = treetank.getResource("grave928134589762", queryParams);
        output = new ByteArrayOutputStream();
        sOutput.write((OutputStream)output);
        doc = DOMHelper.buildDocument(output);
        node = doc.getElementsByTagName("country").item(0);
        attribute = (Attr)node.getAttributes().getNamedItem(IDNAME);
        resultNode = doc.getElementsByTagName(RESULTNAME).item(0);
        AssertJUnit.assertNotNull((String)"test if country exists", (Object)node);
        AssertJUnit.assertNotNull((String)"test if result node exists", (Object)resultNode);
        AssertJUnit.assertNull((String)"test if id element exists", (Object)attribute);
        output.close();
        queryParams.put(QueryParameter.OUTPUT, LITERALTRUE);
        sOutput = treetank.getResource("grave928134589762", queryParams);
        output = new ByteArrayOutputStream();
        sOutput.write((OutputStream)output);
        doc = DOMHelper.buildDocument(output);
        node = doc.getElementsByTagName(NAME).item(0);
        attribute = (Attr)node.getAttributes().getNamedItem(IDNAME);
        resultNode = doc.getElementsByTagName(RESULTNAME).item(0);
        AssertJUnit.assertNotNull((String)"test if country exists2", (Object)node);
        AssertJUnit.assertNotNull((String)"test if result node exists2", (Object)resultNode);
        AssertJUnit.assertNotNull((String)"test if id element exists2", (Object)attribute);
        output.close();
        sOutput = treetank.getResource("grave928134589762", queryParams);
        output = new ByteArrayOutputStream();
        sOutput.write((OutputStream)output);
        doc = DOMHelper.buildDocument(output);
        node = doc.getElementsByTagName("city").item(0);
        attribute = (Attr)node.getAttributes().getNamedItem(IDNAME);
        resultNode = doc.getElementsByTagName(RESULTNAME).item(0);
        AssertJUnit.assertNotNull((String)"test if city exists2", (Object)node);
        AssertJUnit.assertNotNull((String)"test if result node exists2", (Object)resultNode);
        AssertJUnit.assertNotNull((String)"test if id element exists2", (Object)attribute);
        output.close();
    }

    @Test
    public void getResourcesNames() throws TTException, ParserConfigurationException, SAXException, IOException {
        StreamingOutput sOutput = treetank.getResourcesNames();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        sOutput.write((OutputStream)output);
        Document doc = DOMHelper.buildDocument(output);
        NodeList nodes = doc.getElementsByTagName("resource");
        AssertJUnit.assertTrue((String)"Check if a resource exists", (nodes.getLength() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            Attr attribute = (Attr)node.getAttributes().getNamedItem("lastRevision");
            AssertJUnit.assertNotNull((String)"Check if lastRevision exists", (Object)attribute);
            attribute = (Attr)node.getAttributes().getNamedItem(NAME);
            AssertJUnit.assertNotNull((String)"Check if name attribute exists", (Object)attribute);
            AssertJUnit.assertTrue((String)"Check if name is the expected one", (attribute.getTextContent().equals("grave928134589762") || attribute.getTextContent().equals("grave928134589762") ? 1 : 0) != 0);
        }
        output.close();
    }

    @Test
    public void addResource() throws WebApplicationException, IOException, ParserConfigurationException, SAXException, TTException {
        InputStream input = DatabaseRepresentationTest.class.getResourceAsStream("/books.xml");
        treetank.add(input, "grave928134589762");
        HashMap<QueryParameter, String> params = new HashMap<QueryParameter, String>();
        params.put(QueryParameter.WRAP, LITERALTRUE);
        StreamingOutput sOutput = treetank.performQueryOnResource("grave928134589762", ".", params);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        sOutput.write((OutputStream)output);
        Document doc = DOMHelper.buildDocument(output);
        Node node = doc.getElementsByTagName("books").item(0);
        AssertJUnit.assertNotNull((String)"check if books has been added to factbook", (Object)node);
        node = doc.getElementsByTagName("mondial").item(0);
        AssertJUnit.assertNotNull((String)"check if mondial still exists", (Object)node);
        output.close();
    }

    @Test
    public void deleteResource() throws TTException, WebApplicationException, IOException, ParserConfigurationException, SAXException {
        InputStream input = DatabaseRepresentationTest.class.getResourceAsStream(XMLFILE);
        treetank.shred(input, "grave92813458976299");
        treetank.deleteResource("grave92813458976299");
        StreamingOutput sOutput = treetank.getResourcesNames();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        sOutput.write((OutputStream)output);
        Document doc = DOMHelper.buildDocument(output);
        NodeList nodes = doc.getElementsByTagName("resource");
        String searchName = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Attr attribute = (Attr)nodes.item(i).getAttributes().getNamedItem(NAME);
            if (!attribute.getTextContent().equals("grave92813458976299")) continue;
            searchName = attribute.getTextContent();
            break;
        }
        AssertJUnit.assertNull((String)"Check if the resource has been deleted", searchName);
        output.close();
    }

    @Test
    public void shred() throws TTException {
        InputStream input = DatabaseRepresentationTest.class.getResourceAsStream(XMLFILE);
        AssertJUnit.assertTrue((String)ASSTRUE, (boolean)treetank.shred(input, "grave92813458976288"));
        treetank.deleteResource("grave92813458976288");
    }

    @Test
    public void performQueryOnResource() throws WebApplicationException, IOException, ParserConfigurationException, SAXException {
        HashMap<QueryParameter, String> params = new HashMap<QueryParameter, String>();
        params.put(QueryParameter.OUTPUT, LITERALTRUE);
        params.put(QueryParameter.WRAP, LITERALTRUE);
        StreamingOutput sOutput = treetank.performQueryOnResource("grave928134589762", "//continent", params);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        sOutput.write((OutputStream)output);
        Document doc = DOMHelper.buildDocument(output);
        Node node = doc.getElementsByTagName("continent").item(0);
        AssertJUnit.assertNotNull((String)"check if continent exists", (Object)node);
        node = doc.getElementsByTagName("country").item(0);
        AssertJUnit.assertNull((String)"check for null country object", (Object)node);
        output.close();
    }

    @Test
    public void getLastRevision() throws TTException {
        AssertJUnit.assertEquals((String)ASSEQUALS, (long)1L, (long)treetank.getLastRevision("grave928134589762"));
        NodeIdRepresentation rid = new NodeIdRepresentation(CoreTestHelper.getStorage((File)CoreTestHelper.PATHS.PATH1.getFile()));
        rid.deleteResource("grave928134589762", 8L);
        AssertJUnit.assertEquals((String)ASSEQUALS, (long)2L, (long)treetank.getLastRevision("grave928134589762"));
    }

    @Test
    public void getModificHistory() throws WebApplicationException, TTException, SAXException, IOException, ParserConfigurationException {
        NodeIdRepresentation rid = new NodeIdRepresentation(CoreTestHelper.getStorage((File)CoreTestHelper.PATHS.PATH1.getFile()));
        rid.deleteResource("grave928134589762", 8L);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        treetank.getModificHistory("grave928134589762", "1-2", false, (OutputStream)output, true);
        ByteArrayInputStream inpSt = new ByteArrayInputStream(output.toByteArray());
        Document doc = this.xmlDocument(inpSt);
        NodeList nodes = doc.getElementsByTagName("continent");
        int changeditems = nodes.getLength();
        AssertJUnit.assertEquals((String)ASSEQUALS, (int)1, (int)changeditems);
    }

    @Test
    public void revertToRevision() throws TTException, WebApplicationException, IOException, ParserConfigurationException, SAXException, InterruptedException {
        NodeIdRepresentation rid = new NodeIdRepresentation(CoreTestHelper.getStorage((File)CoreTestHelper.PATHS.PATH1.getFile()));
        rid.deleteResource("grave928134589762", 8L);
        rid.deleteResource("grave928134589762", 11L);
        rid.deleteResource("grave928134589762", 14L);
        AssertJUnit.assertEquals((String)ASSEQUALS, (long)4L, (long)treetank.getLastRevision("grave928134589762"));
        treetank.revertToRevision("grave928134589762", 1L);
        StreamingOutput sOutput = rid.getResource("grave928134589762", 14L, new HashMap());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        sOutput.write((OutputStream)output);
        Document doc = DOMHelper.buildDocument(output);
        Node node = doc.getElementsByTagName("continent").item(0);
        Attr attribute = (Attr)node.getAttributes().getNamedItem(NAME);
        String africaString = attribute.getTextContent();
        AssertJUnit.assertNotNull((String)"check if africa (14) exists in the latest version", (Object)africaString);
        AssertJUnit.assertEquals((String)ASSEQUALS, (long)5L, (long)treetank.getLastRevision("grave928134589762"));
        output.close();
    }

    private Document xmlDocument(InputStream input) throws SAXException, IOException, ParserConfigurationException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input);
    }
}

