/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.service.jaxrx.implementation;

import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.parsers.ParserConfigurationException;
import org.jaxrx.core.JaxRxException;
import org.jaxrx.core.QueryParameter;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;
import org.treetank.exception.TTException;
import org.treetank.io.IBackend;
import org.treetank.revisioning.IRevisioning;
import org.treetank.service.jaxrx.enums.EIdAccessType;
import org.treetank.service.jaxrx.implementation.DatabaseRepresentation;
import org.treetank.service.jaxrx.implementation.NodeIdRepresentation;
import org.treetank.service.jaxrx.util.DOMHelper;
import org.treetank.testutil.CoreTestHelper;
import org.treetank.testutil.ModuleFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Guice(moduleFactory=ModuleFactory.class)
public class NodeIdRepresentationTest {
    private static transient NodeIdRepresentation ridWorker;
    private static transient DatabaseRepresentation treetank;
    private static final transient long NODEIDGETRESOURCE = 17L;
    private static final transient long NODEIDTOMODIFY = 11L;
    private static final transient String NAME = "name";
    private static final transient String RESOURCENAME = "factyTest";
    private static final transient String LITERALSTRUE = "yes";
    private static final transient String LITERALSFALSE = "no";
    private static final transient String RESULTNAME = "jaxrx:result";
    private static final transient String IDNAME = "rest:ttid";
    private static final transient String COUNTRYNAME = "country";
    private static final String QUERY = "/descendant-or-self::city/child::name";
    private static final String NODENAME = "myNode";
    @Inject
    public IBackend.IBackendFactory mStorageFac;
    @Inject
    public IRevisioning mRevisioning;

    @BeforeMethod
    public void setUp() throws Exception {
        CoreTestHelper.deleteEverything();
        CoreTestHelper.getStorage((File)CoreTestHelper.PATHS.PATH1.getFile());
        ridWorker = new NodeIdRepresentation(CoreTestHelper.getStorage((File)CoreTestHelper.PATHS.PATH1.getFile()));
        treetank = new DatabaseRepresentation(CoreTestHelper.getStorage((File)CoreTestHelper.PATHS.PATH1.getFile()), this.mStorageFac, this.mRevisioning);
        InputStream input = NodeIdRepresentationTest.class.getClass().getResourceAsStream("/factbook.xml");
        treetank.shred(input, RESOURCENAME);
    }

    @AfterMethod
    public void tearDown() throws Exception {
        CoreTestHelper.deleteEverything();
    }

    @Test
    public final void testGetResource() throws WebApplicationException, IOException, ParserConfigurationException, SAXException {
        HashMap<QueryParameter, String> queryParams = new HashMap<QueryParameter, String>();
        queryParams.put(QueryParameter.OUTPUT, LITERALSTRUE);
        queryParams.put(QueryParameter.WRAP, LITERALSTRUE);
        queryParams.put(QueryParameter.REVISION, "0");
        StreamingOutput result = ridWorker.getResource(RESOURCENAME, 17L, queryParams);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        result.write((OutputStream)outputStream);
        Document doc = DOMHelper.buildDocument(outputStream);
        NodeList list = doc.getElementsByTagName("city");
        Node node = list.item(0);
        Attr attribute = (Attr)node.getAttributes().getNamedItem(IDNAME);
        NodeList resultList = doc.getElementsByTagName(RESULTNAME);
        Node resultNode = resultList.item(0);
        outputStream.close();
        AssertJUnit.assertNotNull((String)"Test if node exist 1a", (Object)node);
        AssertJUnit.assertNotNull((String)"Test if node exist 1b", (Object)resultNode);
        AssertJUnit.assertNotNull((String)"Test if node exist 1c", (Object)attribute);
        queryParams.clear();
        queryParams.put(QueryParameter.OUTPUT, LITERALSFALSE);
        queryParams.put(QueryParameter.QUERY, null);
        queryParams.put(QueryParameter.WRAP, LITERALSFALSE);
        queryParams.put(QueryParameter.REVISION, null);
        result = ridWorker.getResource(RESOURCENAME, 17L, queryParams);
        outputStream = new ByteArrayOutputStream();
        result.write((OutputStream)outputStream);
        doc = DOMHelper.buildDocument(outputStream);
        list = doc.getElementsByTagName(COUNTRYNAME);
        node = list.item(0);
        attribute = (Attr)node.getAttributes().getNamedItem(IDNAME);
        resultNode = doc.getElementsByTagName(RESULTNAME).item(0);
        outputStream.close();
        AssertJUnit.assertNotNull((String)"Test if node exist 2a", (Object)node);
        AssertJUnit.assertNull((String)"Test if node exist 2b", (Object)resultNode);
        AssertJUnit.assertNull((String)"Test if node exist 2c", (Object)attribute);
        queryParams.clear();
        queryParams.put(QueryParameter.OUTPUT, LITERALSFALSE);
        queryParams.put(QueryParameter.WRAP, LITERALSTRUE);
        queryParams.put(QueryParameter.REVISION, null);
        result = ridWorker.getResource(RESOURCENAME, 17L, queryParams);
        outputStream = new ByteArrayOutputStream();
        result.write((OutputStream)outputStream);
        doc = DOMHelper.buildDocument(outputStream);
        list = doc.getElementsByTagName("city");
        node = list.item(0);
        attribute = (Attr)node.getAttributes().getNamedItem(IDNAME);
        resultNode = doc.getElementsByTagName(RESULTNAME).item(0);
        outputStream.close();
        AssertJUnit.assertNotNull((String)"Test if node exist 3a", (Object)node);
        AssertJUnit.assertNotNull((String)"Test if node exist 3b", (Object)resultNode);
        AssertJUnit.assertNull((String)"Test if node exist 3c", (Object)attribute);
        queryParams.clear();
        queryParams.put(QueryParameter.OUTPUT, LITERALSFALSE);
        queryParams.put(QueryParameter.WRAP, LITERALSTRUE);
        queryParams.put(QueryParameter.REVISION, "0");
        result = ridWorker.getResource(RESOURCENAME, 17L, queryParams);
        outputStream = new ByteArrayOutputStream();
        result.write((OutputStream)outputStream);
        doc = DOMHelper.buildDocument(outputStream);
        list = doc.getElementsByTagName(COUNTRYNAME);
        node = list.item(0);
        attribute = (Attr)node.getAttributes().getNamedItem(IDNAME);
        resultNode = doc.getElementsByTagName(RESULTNAME).item(0);
        outputStream.close();
        AssertJUnit.assertNotNull((String)"Test if node exist 4a", (Object)node);
        AssertJUnit.assertNotNull((String)"Test if node exist 4b", (Object)resultNode);
        AssertJUnit.assertNull((String)"Test if node exist 4c", (Object)attribute);
    }

    @Test
    public final void testGetResourceByAT() throws WebApplicationException, IOException, ParserConfigurationException, SAXException {
        HashMap<QueryParameter, String> queryParams = new HashMap<QueryParameter, String>();
        queryParams.put(QueryParameter.OUTPUT, LITERALSTRUE);
        queryParams.put(QueryParameter.WRAP, LITERALSTRUE);
        queryParams.put(QueryParameter.REVISION, "1");
        String textContent = null;
        StreamingOutput fChildOutput = ridWorker.getResourceByAT(RESOURCENAME, 17L, queryParams, EIdAccessType.FIRSTCHILD);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        fChildOutput.write((OutputStream)outputStream);
        Document doc = DOMHelper.buildDocument(outputStream);
        NodeList list = doc.getElementsByTagName(NAME);
        Node node = list.item(0);
        textContent = node.getTextContent();
        outputStream.close();
        AssertJUnit.assertEquals((String)"Test expected name ", (String)"Albania", (String)textContent);
        StreamingOutput lChildOutput = ridWorker.getResourceByAT(RESOURCENAME, 17L, queryParams, EIdAccessType.LASTCHILD);
        outputStream = new ByteArrayOutputStream();
        lChildOutput.write((OutputStream)outputStream);
        doc = DOMHelper.buildDocument(outputStream);
        list = doc.getElementsByTagName("border");
        node = list.item(0);
        Attr attribute = (Attr)node.getAttributes().getNamedItem("length");
        outputStream.close();
        AssertJUnit.assertEquals((String)"Test expected border value ", (String)"287", (String)attribute.getValue());
        StreamingOutput rSiblingOutput = ridWorker.getResourceByAT(RESOURCENAME, 17L, queryParams, EIdAccessType.RIGHTSIBLING);
        outputStream = new ByteArrayOutputStream();
        rSiblingOutput.write((OutputStream)outputStream);
        doc = DOMHelper.buildDocument(outputStream);
        list = doc.getElementsByTagName(COUNTRYNAME);
        node = list.item(0);
        attribute = (Attr)node.getAttributes().getNamedItem(NAME);
        outputStream.close();
        AssertJUnit.assertEquals((String)"Test expected right sibling name ", (String)"Andorra", (String)attribute.getValue());
        StreamingOutput lSiblingOutput = ridWorker.getResourceByAT(RESOURCENAME, 17L, queryParams, EIdAccessType.LEFTSIBLING);
        outputStream = new ByteArrayOutputStream();
        lSiblingOutput.write((OutputStream)outputStream);
        doc = DOMHelper.buildDocument(outputStream);
        list = doc.getElementsByTagName("continent");
        node = list.item(0);
        attribute = (Attr)node.getAttributes().getNamedItem(NAME);
        outputStream.close();
        AssertJUnit.assertEquals((String)"Test expected right sibling name ", (String)"Africa", (String)attribute.getValue());
    }

    @Test
    public final void testPerformQueryOnResource() throws WebApplicationException, IOException, ParserConfigurationException, SAXException {
        HashMap<QueryParameter, String> queryParams = new HashMap<QueryParameter, String>();
        queryParams.put(QueryParameter.OUTPUT, LITERALSTRUE);
        queryParams.put(QueryParameter.WRAP, LITERALSTRUE);
        queryParams.put(QueryParameter.REVISION, "1");
        String textContent = null;
        StreamingOutput output = ridWorker.performQueryOnResource(RESOURCENAME, 17L, QUERY, queryParams);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        output.write((OutputStream)outputStream);
        Document doc = DOMHelper.buildDocument(outputStream);
        NodeList list = doc.getElementsByTagName(NAME);
        Node node = list.item(0);
        Attr attribute = (Attr)node.getAttributes().getNamedItem(IDNAME);
        Node resultNode = doc.getElementsByTagName(RESULTNAME).item(0);
        textContent = node.getTextContent();
        AssertJUnit.assertEquals((String)"Test expected city Tirane", (String)"Tirane", (String)textContent);
        AssertJUnit.assertNotNull((String)"Test if wrapping is available", (Object)resultNode);
        AssertJUnit.assertNotNull((String)"Test if node id is supported", (Object)attribute);
        node = list.item(list.getLength() - 1);
        textContent = node.getTextContent();
        outputStream.close();
        AssertJUnit.assertEquals((String)"Test expected city Korce", (String)"Korce", (String)textContent);
        queryParams.clear();
        queryParams.put(QueryParameter.OUTPUT, LITERALSFALSE);
        queryParams.put(QueryParameter.WRAP, LITERALSTRUE);
        queryParams.put(QueryParameter.REVISION, "1");
        output = ridWorker.performQueryOnResource(RESOURCENAME, 17L, QUERY, queryParams);
        outputStream = new ByteArrayOutputStream();
        output.write((OutputStream)outputStream);
        doc = DOMHelper.buildDocument(outputStream);
        list = doc.getElementsByTagName(NAME);
        node = list.item(0);
        textContent = node.getTextContent();
        attribute = (Attr)node.getAttributes().getNamedItem(IDNAME);
        resultNode = doc.getElementsByTagName(RESULTNAME).item(0);
        outputStream.close();
        AssertJUnit.assertEquals((String)"Test expected city name Tirane", (String)"Tirane", (String)textContent);
        AssertJUnit.assertNotNull((String)"Test if wrapping is supported", (Object)resultNode);
        AssertJUnit.assertNull((String)"Test if node id is not supported", (Object)attribute);
    }

    @Test
    public final void testDeleteResource() throws WebApplicationException, IOException, ParserConfigurationException, SAXException, InterruptedException {
        ridWorker.deleteResource(RESOURCENAME, 17L);
        HashMap<QueryParameter, String> queryParams = new HashMap<QueryParameter, String>();
        queryParams.put(QueryParameter.OUTPUT, LITERALSTRUE);
        queryParams.put(QueryParameter.WRAP, LITERALSFALSE);
        StreamingOutput result = ridWorker.performQueryOnResource(RESOURCENAME, 1L, "//country[@name=\"Albania\"]", queryParams);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write("<resulti>".getBytes());
        result.write((OutputStream)outputStream);
        outputStream.write("</resulti>".getBytes());
        Document doc = DOMHelper.buildDocument(outputStream);
        NodeList list = doc.getElementsByTagName(COUNTRYNAME);
        Node searchedNode = null;
        for (int i = 0; i < list.getLength(); ++i) {
            Element elem = (Element)list.item(i);
            Attr name = elem.getAttributeNode(NAME);
            if (!name.getTextContent().equals("Albania")) continue;
            searchedNode = list.item(i);
            break;
        }
        outputStream.close();
        AssertJUnit.assertNull((String)"Country Albania does not exist anymore", searchedNode);
    }

    @Test
    public final void testModifyResource() throws JaxRxException, TTException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream("<testNode/>".getBytes());
        long lastRevision = treetank.getLastRevision(RESOURCENAME);
        ridWorker.modifyResource(RESOURCENAME, 11L, (InputStream)inputStream);
        AssertJUnit.assertEquals((String)"Test modify resource", (long)treetank.getLastRevision(RESOURCENAME), (long)(++lastRevision));
    }

    @Test
    public final void testAddSubResource() throws WebApplicationException, IOException, ParserConfigurationException, SAXException {
        HashMap<QueryParameter, String> queryParams = new HashMap<QueryParameter, String>();
        queryParams.put(QueryParameter.OUTPUT, LITERALSTRUE);
        queryParams.put(QueryParameter.WRAP, LITERALSTRUE);
        HashMap queryParamsComp = new HashMap();
        queryParams.put(QueryParameter.OUTPUT, LITERALSTRUE);
        ByteArrayInputStream newNode = new ByteArrayInputStream("<myNode><test>hello</test></myNode>".getBytes());
        ridWorker.addSubResource(RESOURCENAME, 17L, (InputStream)newNode, EIdAccessType.FIRSTCHILD);
        StreamingOutput result = ridWorker.getResourceByAT(RESOURCENAME, 17L, queryParamsComp, EIdAccessType.FIRSTCHILD);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        result.write((OutputStream)outputStream);
        Document doc = DOMHelper.buildDocument(outputStream);
        NodeList list = doc.getElementsByTagName(NODENAME);
        Node node = list.item(0);
        outputStream.close();
        AssertJUnit.assertNotNull((String)"Test if first child exist after inserting", (Object)node);
        ((InputStream)newNode).reset();
        ridWorker.addSubResource(RESOURCENAME, 17L, (InputStream)newNode, EIdAccessType.LASTCHILD);
        result = ridWorker.getResourceByAT(RESOURCENAME, 17L, queryParamsComp, EIdAccessType.LASTCHILD);
        outputStream = new ByteArrayOutputStream();
        result.write((OutputStream)outputStream);
        doc = DOMHelper.buildDocument(outputStream);
        list = doc.getElementsByTagName(NODENAME);
        node = list.item(0);
        outputStream.close();
        AssertJUnit.assertNotNull((String)"Test if last child exist after inserting", (Object)node);
        ((InputStream)newNode).reset();
        ridWorker.addSubResource(RESOURCENAME, 17L, (InputStream)newNode, EIdAccessType.LEFTSIBLING);
        result = ridWorker.getResourceByAT(RESOURCENAME, 17L, queryParamsComp, EIdAccessType.LEFTSIBLING);
        outputStream = new ByteArrayOutputStream();
        result.write((OutputStream)outputStream);
        doc = DOMHelper.buildDocument(outputStream);
        list = doc.getElementsByTagName(NODENAME);
        node = list.item(0);
        outputStream.close();
        AssertJUnit.assertNotNull((String)"Test if left sibling exist after inserting", (Object)node);
        ((InputStream)newNode).reset();
        ridWorker.addSubResource(RESOURCENAME, 17L, (InputStream)newNode, EIdAccessType.RIGHTSIBLING);
        result = ridWorker.getResourceByAT(RESOURCENAME, 17L, queryParamsComp, EIdAccessType.RIGHTSIBLING);
        outputStream = new ByteArrayOutputStream();
        result.write((OutputStream)outputStream);
        doc = DOMHelper.buildDocument(outputStream);
        list = doc.getElementsByTagName(NODENAME);
        node = list.item(0);
        outputStream.close();
        AssertJUnit.assertNotNull((String)"Test if right sibling exist after inserting", (Object)node);
    }
}

