/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.service.jaxrx.util;

import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.parsers.ParserConfigurationException;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;
import org.treetank.api.IStorage;
import org.treetank.exception.TTException;
import org.treetank.io.IBackend;
import org.treetank.revisioning.IRevisioning;
import org.treetank.service.jaxrx.implementation.DatabaseRepresentation;
import org.treetank.service.jaxrx.implementation.NodeIdRepresentationTest;
import org.treetank.service.jaxrx.util.DOMHelper;
import org.treetank.service.jaxrx.util.RESTResponseHelper;
import org.treetank.testutil.CoreTestHelper;
import org.treetank.testutil.ModuleFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Guice(moduleFactory=ModuleFactory.class)
public class RESTResponseHelperTest {
    private static final String NAME = "name";
    private static final String SHAKE = "shakespeare";
    private static final String BOOK = "books";
    private static final String FACT = "factbook";
    private static final String EBAY = "ebay";
    private static final String RESPATH = "/factbook.xml";
    @Inject
    public IBackend.IBackendFactory mStorageFac;
    @Inject
    public IRevisioning mRevisioning;

    @BeforeMethod
    public void before() throws TTException {
        CoreTestHelper.deleteEverything();
        CoreTestHelper.getStorage((File)CoreTestHelper.PATHS.PATH1.getFile());
    }

    @AfterMethod
    public void after() throws TTException {
        CoreTestHelper.deleteEverything();
    }

    @Test
    public final void testBuildResponseOfDomLR() throws WebApplicationException, IOException, ParserConfigurationException, SAXException, TTException, InterruptedException {
        ArrayList<String> availResources = new ArrayList<String>();
        availResources.add(FACT);
        availResources.add(EBAY);
        availResources.add(BOOK);
        availResources.add(SHAKE);
        DatabaseRepresentation treetank = new DatabaseRepresentation(CoreTestHelper.getStorage((File)CoreTestHelper.PATHS.PATH1.getFile()), this.mStorageFac, this.mRevisioning);
        InputStream input = NodeIdRepresentationTest.class.getClass().getResourceAsStream(RESPATH);
        treetank.shred(input, FACT);
        input.close();
        input = NodeIdRepresentationTest.class.getClass().getResourceAsStream(RESPATH);
        treetank.shred(input, EBAY);
        input.close();
        input.close();
        input = NodeIdRepresentationTest.class.getClass().getResourceAsStream(RESPATH);
        treetank.add(input, BOOK);
        input = NodeIdRepresentationTest.class.getClass().getResourceAsStream(RESPATH);
        treetank.shred(input, SHAKE);
        input.close();
        StreamingOutput result = RESTResponseHelper.buildResponseOfDomLR((IStorage)CoreTestHelper.getStorage((File)CoreTestHelper.PATHS.PATH1.getFile()), (IBackend.IBackendFactory)this.mStorageFac, (IRevisioning)this.mRevisioning);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        result.write((OutputStream)outputStream);
        Document doc = DOMHelper.buildDocument(outputStream);
        NodeList listRes = doc.getElementsByTagName("resource");
        AssertJUnit.assertEquals((String)"Test for the length of resource", (int)4, (int)listRes.getLength());
        HashSet<String> names = new HashSet<String>();
        names.add(listRes.item(0).getAttributes().getNamedItem(NAME).getTextContent());
        names.add(listRes.item(1).getAttributes().getNamedItem(NAME).getTextContent());
        names.add(listRes.item(2).getAttributes().getNamedItem(NAME).getTextContent());
        names.add(listRes.item(3).getAttributes().getNamedItem(NAME).getTextContent());
        AssertJUnit.assertTrue((boolean)names.remove(FACT));
        AssertJUnit.assertTrue((boolean)names.remove(EBAY));
        AssertJUnit.assertTrue((boolean)names.remove(BOOK));
        AssertJUnit.assertTrue((boolean)names.remove(SHAKE));
        AssertJUnit.assertEquals((String)"Size of test-structure must be 0", (int)0, (int)names.size());
        outputStream.close();
        treetank.deleteResource(EBAY);
        treetank.deleteResource(FACT);
        treetank.deleteResource(BOOK);
        treetank.deleteResource(SHAKE);
    }
}

