/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.service.jaxrx.util;

import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;
import org.treetank.exception.TTException;
import org.treetank.io.IBackend;
import org.treetank.revisioning.IRevisioning;
import org.treetank.service.jaxrx.implementation.DatabaseRepresentation;
import org.treetank.service.jaxrx.util.RestXPathProcessor;
import org.treetank.testutil.CoreTestHelper;
import org.treetank.testutil.ModuleFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Guice(moduleFactory=ModuleFactory.class)
public class RestXPathProcessorTest {
    private transient RestXPathProcessor rxProcessor;
    private static final transient String RESOURCENAME = "books";
    public static final transient String PARAMBOOKS = "book";
    public static final transient String PARAMAUTHOR = "author";
    public static final transient String PARAMJAXRES = "jaxrx:result";
    public static final transient String PARAMJRESTSEQ = "rest:sequence";
    @Inject
    public IBackend.IBackendFactory mStorageFac;
    @Inject
    public IRevisioning mRevisioning;

    @BeforeMethod
    public void setUpGlobal() throws TTException {
        CoreTestHelper.deleteEverything();
        this.rxProcessor = new RestXPathProcessor(CoreTestHelper.getStorage((File)CoreTestHelper.PATHS.PATH1.getFile()));
        InputStream xmlInput = RestXPathProcessorTest.class.getResourceAsStream("/books.xml");
        new DatabaseRepresentation(CoreTestHelper.getStorage((File)CoreTestHelper.PATHS.PATH1.getFile()), this.mStorageFac, this.mRevisioning).shred(xmlInput, RESOURCENAME);
    }

    @Test
    public final void testRestXPathProcessor() throws TTException {
        RestXPathProcessor reference = new RestXPathProcessor(CoreTestHelper.getStorage((File)CoreTestHelper.PATHS.PATH1.getFile()));
        AssertJUnit.assertNotNull((String)"checks if the reference is not null and constructor works", (Object)reference);
    }

    @Test
    public final void testGetXpathResourceStringStringBooleanLongOutputStreamBoolean() throws IOException, SAXException, ParserConfigurationException, TTException {
        String xPath = "//book";
        boolean withNodeIds = true;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.rxProcessor.getXpathResource(RESOURCENAME, xPath, withNodeIds, Long.valueOf(1L), (OutputStream)output, true);
        ByteArrayInputStream xmlInput = new ByteArrayInputStream(output.toByteArray());
        Document resultDoc = this.xmlDocument(xmlInput);
        NodeList bNodes = resultDoc.getElementsByTagName(PARAMBOOKS);
        AssertJUnit.assertEquals((String)"test for items size of books is 6", (int)6, (int)bNodes.getLength());
        NodeList aNodes = resultDoc.getElementsByTagName(PARAMAUTHOR);
        AssertJUnit.assertEquals((String)"test for items size of authors is 12", (int)12, (int)aNodes.getLength());
        NodeList rNodes = resultDoc.getElementsByTagName(PARAMJAXRES);
        AssertJUnit.assertEquals((String)"test for existence of result element is 1", (int)1, (int)rNodes.getLength());
        NodeList iNodes = resultDoc.getElementsByTagName(PARAMJRESTSEQ);
        AssertJUnit.assertEquals((String)"test for existence of node ids", (int)6, (int)iNodes.getLength());
        xPath = "//author";
        withNodeIds = false;
        output = new ByteArrayOutputStream();
        this.rxProcessor.getXpathResource(RESOURCENAME, xPath, withNodeIds, null, (OutputStream)output, true);
        xmlInput = new ByteArrayInputStream(output.toByteArray());
        resultDoc = this.xmlDocument(xmlInput);
        NodeList b2Nodes = resultDoc.getElementsByTagName(PARAMBOOKS);
        AssertJUnit.assertEquals((String)"test for items size of books is 0", (int)0, (int)b2Nodes.getLength());
        NodeList a2Nodes = resultDoc.getElementsByTagName(PARAMAUTHOR);
        AssertJUnit.assertEquals((String)"test for items size of authors", (int)12, (int)a2Nodes.getLength());
        NodeList r2Nodes = resultDoc.getElementsByTagName(PARAMJAXRES);
        AssertJUnit.assertEquals((String)"test for existence of result element", (int)1, (int)r2Nodes.getLength());
        NodeList i2Nodes = resultDoc.getElementsByTagName(PARAMJRESTSEQ);
        AssertJUnit.assertEquals((String)"test for existence of node ids", (int)0, (int)i2Nodes.getLength());
    }

    @Test
    public final void testGetXpathResourceFileLongStringBooleanLongOutputStreamBoolean() throws SAXException, IOException, ParserConfigurationException, TTException {
        String xPath = "//author";
        boolean withNodeIds = true;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.rxProcessor.getXpathResource(RESOURCENAME, 10L, xPath, withNodeIds, Long.valueOf(1L), (OutputStream)output, true);
        ByteArrayInputStream xmlInput = new ByteArrayInputStream(output.toByteArray());
        Document resultDoc = this.xmlDocument(xmlInput);
        NodeList bNodes = resultDoc.getElementsByTagName(PARAMBOOKS);
        AssertJUnit.assertEquals((String)"test for items size of books", (int)0, (int)bNodes.getLength());
        NodeList aNodes = resultDoc.getElementsByTagName(PARAMAUTHOR);
        AssertJUnit.assertEquals((String)"test for items size of authors is 2", (int)2, (int)aNodes.getLength());
        NodeList rNodes = resultDoc.getElementsByTagName(PARAMJAXRES);
        AssertJUnit.assertEquals((String)"test for item of result element is 1", (int)1, (int)rNodes.getLength());
        NodeList iNodes = resultDoc.getElementsByTagName(PARAMJRESTSEQ);
        AssertJUnit.assertEquals((String)"test for existence of node ids", (int)2, (int)iNodes.getLength());
        xPath = "//author";
        withNodeIds = false;
        output = new ByteArrayOutputStream();
        this.rxProcessor.getXpathResource(RESOURCENAME, 10L, xPath, withNodeIds, null, (OutputStream)output, true);
        xmlInput = new ByteArrayInputStream(output.toByteArray());
        resultDoc = this.xmlDocument(xmlInput);
        NodeList b2Nodes = resultDoc.getElementsByTagName(PARAMBOOKS);
        AssertJUnit.assertEquals((String)"test for item size of books", (int)0, (int)b2Nodes.getLength());
        NodeList a2Nodes = resultDoc.getElementsByTagName(PARAMAUTHOR);
        AssertJUnit.assertEquals((String)"test for item size of authors", (int)2, (int)a2Nodes.getLength());
        NodeList r2Nodes = resultDoc.getElementsByTagName(PARAMJAXRES);
        AssertJUnit.assertEquals((String)"test of result element", (int)1, (int)r2Nodes.getLength());
        NodeList i2Nodes = resultDoc.getElementsByTagName(PARAMJRESTSEQ);
        AssertJUnit.assertEquals((String)"test existence of node ids", (int)0, (int)i2Nodes.getLength());
    }

    private Document xmlDocument(InputStream input) throws SAXException, IOException, ParserConfigurationException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input);
    }
}

