/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.service.jaxrx.util;

import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;
import org.treetank.access.NodeReadTrx;
import org.treetank.access.NodeWriteTrx;
import org.treetank.access.Storage;
import org.treetank.access.conf.SessionConfiguration;
import org.treetank.access.conf.StandardSettings;
import org.treetank.api.INodeReadTrx;
import org.treetank.api.INodeWriteTrx;
import org.treetank.api.ISession;
import org.treetank.api.IStorage;
import org.treetank.exception.TTException;
import org.treetank.io.IBackend;
import org.treetank.revisioning.IRevisioning;
import org.treetank.service.jaxrx.implementation.DatabaseRepresentation;
import org.treetank.service.jaxrx.util.WorkerHelper;
import org.treetank.service.xml.shredder.EShredderInsert;
import org.treetank.testutil.CoreTestHelper;
import org.treetank.testutil.ModuleFactory;

@Guice(moduleFactory=ModuleFactory.class)
public class WorkerHelperTest {
    private static transient WorkerHelper workerHelper;
    private static transient DatabaseRepresentation treetank;
    private static final transient String RESOURCENAME = "factyTest";
    private static final File DBFILE;
    @Inject
    public IBackend.IBackendFactory mStorageFac;
    @Inject
    public IRevisioning mRevisioning;

    @BeforeMethod
    public void setUp() throws FileNotFoundException, TTException {
        CoreTestHelper.deleteEverything();
        CoreTestHelper.getStorage((File)CoreTestHelper.PATHS.PATH1.getFile());
        workerHelper = WorkerHelper.getInstance();
        treetank = new DatabaseRepresentation(CoreTestHelper.getStorage((File)CoreTestHelper.PATHS.PATH1.getFile()), this.mStorageFac, this.mRevisioning);
        InputStream inputfile = WorkerHelperTest.class.getClass().getResourceAsStream("/factbook.xml");
        treetank.shred(inputfile, RESOURCENAME);
    }

    @AfterMethod
    public void after() throws TTException {
        CoreTestHelper.deleteEverything();
    }

    @Test
    public void testCreateStringBuilderObject() {
        AssertJUnit.assertNotNull((String)"test create string builder object", (Object)workerHelper.createStringBuilderObject());
    }

    @Test
    public void testSerializeXML() throws TTException, IOException {
        IStorage storage = Storage.openStorage((File)DBFILE.getParentFile());
        ISession session = storage.getSession(new SessionConfiguration(DBFILE.getName(), StandardSettings.KEY));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        AssertJUnit.assertNotNull((String)"test serialize xml", (Object)WorkerHelper.serializeXML((ISession)session, (OutputStream)out, (boolean)true, (boolean)true, null));
        session.close();
        storage.close();
        ((OutputStream)out).close();
    }

    @Test
    public void testShredInputStream() throws TTException, IOException {
        long lastRevision = treetank.getLastRevision(RESOURCENAME);
        IStorage storage = Storage.openStorage((File)DBFILE.getParentFile());
        ISession session = storage.getSession(new SessionConfiguration(DBFILE.getName(), StandardSettings.KEY));
        NodeWriteTrx wtx = new NodeWriteTrx(session, session.beginBucketWtx(), NodeWriteTrx.HashKind.Rolling);
        ByteArrayInputStream inputStream = new ByteArrayInputStream("<testNode/>".getBytes());
        WorkerHelper.shredInputStream((INodeWriteTrx)wtx, (InputStream)inputStream, (EShredderInsert)EShredderInsert.ADDASFIRSTCHILD);
        AssertJUnit.assertEquals((String)"test shred input stream", (long)treetank.getLastRevision(RESOURCENAME), (long)(++lastRevision));
        wtx.close();
        session.close();
        storage.close();
        ((InputStream)inputStream).close();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testClose() throws TTException {
        IStorage storage = Storage.openStorage((File)DBFILE.getParentFile());
        ISession session = storage.getSession(new SessionConfiguration(DBFILE.getName(), StandardSettings.KEY));
        NodeWriteTrx wtx = new NodeWriteTrx(session, session.beginBucketWtx(), NodeWriteTrx.HashKind.Rolling);
        WorkerHelper.closeWTX((boolean)false, (INodeWriteTrx)wtx, (ISession)session);
        wtx.commit();
        storage = Storage.openStorage((File)DBFILE.getParentFile());
        session = storage.getSession(new SessionConfiguration(DBFILE.getName(), StandardSettings.KEY));
        NodeReadTrx rtx = new NodeReadTrx(session.beginBucketRtx(session.getMostRecentVersion()));
        WorkerHelper.closeRTX((INodeReadTrx)rtx, (ISession)session);
        rtx.moveTo(11L);
    }

    static {
        DBFILE = new File(CoreTestHelper.PATHS.PATH1.getFile(), RESOURCENAME);
    }
}

