/*
 * Decompiled with CFR 0.152.
 */
package org.jaxrx.core;

import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.core.HttpHeaders;
import org.jaxrx.core.QueryParameter;

@Path(value="/")
public final class ResourcePath {
    private final Map<QueryParameter, String> params;
    private final String[] resource;
    private final HttpHeaders headers;

    public ResourcePath(String resourcePath) {
        this(resourcePath, null, null);
    }

    public ResourcePath(String resourcePath, Map<QueryParameter, String> queryParameters) {
        this(resourcePath, queryParameters, null);
    }

    public ResourcePath(String resourcePath, HttpHeaders httpHeaders) {
        this(resourcePath, null, httpHeaders);
    }

    public ResourcePath(String resourcePath, Map<QueryParameter, String> queryParameters, HttpHeaders httpHeaders) {
        String[] rp = resourcePath.replaceAll("/+$", "").split("/");
        this.resource = rp.length == 1 && rp[0].isEmpty() ? new String[]{} : rp;
        this.params = queryParameters;
        this.headers = httpHeaders;
    }

    public String getResourcePath() {
        StringBuilder sb = new StringBuilder();
        for (String r : this.resource) {
            sb.append(r + '/');
        }
        return sb.substring(0, Math.max(0, sb.length() - 1));
    }

    public String getResource(int level) {
        if (level < this.resource.length) {
            return this.resource[level];
        }
        throw new IndexOutOfBoundsException("Index: " + level + ", Size: " + this.resource.length);
    }

    public int getDepth() {
        return this.resource.length;
    }

    public String getValue(QueryParameter key) {
        return this.params != null ? this.params.get((Object)key) : null;
    }

    public Map<QueryParameter, String> getQueryParameter() {
        return this.params;
    }

    public HttpHeaders getHttpHeaders() {
        return this.headers;
    }

    public String toString() {
        return this.getResourcePath();
    }
}

