/*
 * Decompiled with CFR 0.152.
 */
package org.jaxrx.core;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jaxrx.core.JaxRxException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ResponseBuilder {
    private ResponseBuilder() {
    }

    private static Document createSurroundingXMLResp() throws ParserConfigurationException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
    }

    private static List<Element> createCollectionElement(List<String> pathResource, Document document) {
        ArrayList<Element> collections = new ArrayList<Element>();
        for (String path : pathResource) {
            Element collection = document.createElementNS("http://jax-rx.sourceforge.net", "jax-rx:resource");
            collection.setAttribute("name", path);
            collections.add(collection);
        }
        return collections;
    }

    private static Element createResultElement(Document document) {
        return document.createElementNS("http://jax-rx.sourceforge.net", "jax-rx:results");
    }

    public static StreamingOutput buildDOMResponse(List<String> availableResources) {
        try {
            Document document = ResponseBuilder.createSurroundingXMLResp();
            Element resElement = ResponseBuilder.createResultElement(document);
            List<Element> resources = ResponseBuilder.createCollectionElement(availableResources, document);
            for (Element resource : resources) {
                resElement.appendChild(resource);
            }
            document.appendChild(resElement);
            return ResponseBuilder.createStream(document);
        }
        catch (ParserConfigurationException exc) {
            throw new JaxRxException(exc);
        }
    }

    public static StreamingOutput createStream(final Document doc) {
        return new StreamingOutput(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(OutputStream output) {
                OutputStream outputStream = output;
                synchronized (outputStream) {
                    DOMSource domSource = new DOMSource(doc);
                    StreamResult streamResult = new StreamResult(output);
                    try {
                        Transformer transformer = TransformerFactory.newInstance().newTransformer();
                        transformer.transform(domSource, streamResult);
                    }
                    catch (TransformerException exc) {
                        exc.printStackTrace();
                        throw new JaxRxException(exc);
                    }
                }
            }
        };
    }
}

