/*
 * Decompiled with CFR 0.152.
 */
package org.jaxrx.core;

import java.util.HashMap;
import java.util.Map;
import org.jaxrx.JaxRx;
import org.jaxrx.core.JaxRxException;

public final class Systems {
    private static final String VALDELIM = ";";
    private static final Map<String, String> SYSTEMSIMPLS = new HashMap<String, String>();
    private static final Map<String, JaxRx> INSTANCES = new HashMap<String, JaxRx>();

    private Systems() {
    }

    public static Map<String, String> getSystems() {
        return SYSTEMSIMPLS;
    }

    public static JaxRx getInstance(String impl) {
        String path = Systems.getSystems().get(impl);
        if (path == null) {
            throw new JaxRxException(404, "Unknown implementation: " + impl);
        }
        JaxRx jaxrx = INSTANCES.get(path);
        if (jaxrx == null) {
            try {
                jaxrx = (JaxRx)Class.forName(path).newInstance();
                INSTANCES.put(path, jaxrx);
            }
            catch (Exception ex) {
                throw new JaxRxException(ex);
            }
        }
        return jaxrx;
    }

    static {
        String systemVal = System.getProperty(Sys.SYSTEMNAME.key);
        String implVal = System.getProperty(Sys.IMPLEMENTATION.key);
        if (systemVal != null && implVal != null) {
            String[] systemValSplitted = systemVal.split(VALDELIM);
            String[] implValSplitted = implVal.split(VALDELIM);
            for (int i = 0; i < systemVal.split(VALDELIM).length; ++i) {
                SYSTEMSIMPLS.put(systemValSplitted[i], implValSplitted[i]);
            }
        } else if (systemVal == null && implVal == null) {
            SYSTEMSIMPLS.put(Sys.SYSTEMNAME.value, Sys.IMPLEMENTATION.value);
        } else {
            throw new IllegalStateException();
        }
    }

    private static enum Sys {
        IMPLEMENTATION("org.jaxrx.systemPath", "org.jaxrx.dom.DOMJaxRx"),
        SYSTEMNAME("org.jaxrx.systemName", "dom");

        final String key;
        final String value;

        private Sys(String paramKey, String paramValue) {
            this.key = paramKey;
            this.value = paramValue;
        }
    }
}

