/*
 * Decompiled with CFR 0.152.
 */
package org.jaxrx.resource;

import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jaxrx.JaxRx;
import org.jaxrx.core.ResourcePath;
import org.jaxrx.core.Systems;
import org.jaxrx.resource.AResource;

@Path(value="/{system}/jax-rx/{resource:.+}")
public final class XMLResource
extends AResource {
    @GET
    public Response getResource(@PathParam(value="system") String system, @PathParam(value="resource") String resource, @Context UriInfo uri, @Context HttpHeaders headers) {
        return this.getResource(system, uri, resource, headers);
    }

    @POST
    @Consumes(value={"application/query+xml"})
    public Response postQuery(@PathParam(value="system") String system, @PathParam(value="resource") String resource, @Context HttpHeaders headers, InputStream input) {
        return this.postQuery(system, input, resource, headers);
    }

    @POST
    @Consumes(value={"text/xml", "application/xml"})
    public Response postResource(@PathParam(value="system") String system, @PathParam(value="resource") String resource, @Context HttpHeaders headers, InputStream input) {
        JaxRx impl = Systems.getInstance(system);
        String info = impl.add(input, new ResourcePath(resource, headers));
        return Response.created(null).entity((Object)info).build();
    }

    @PUT
    @Consumes(value={"text/xml", "application/xml"})
    public Response putResource(@PathParam(value="system") String system, @PathParam(value="resource") String resource, @Context HttpHeaders headers, InputStream xml) {
        JaxRx impl = Systems.getInstance(system);
        String info = impl.update(xml, new ResourcePath(resource, headers));
        return Response.created(null).entity((Object)info).build();
    }

    @DELETE
    public Response deleteResource(@PathParam(value="system") String system, @PathParam(value="resource") String resource, @Context HttpHeaders headers) {
        JaxRx impl = Systems.getInstance(system);
        String info = impl.delete(new ResourcePath(resource, headers));
        return Response.ok().entity((Object)info).build();
    }
}

