/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.service.jaxrx.implementation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.jaxrx.core.JaxRxException;
import org.jaxrx.core.QueryParameter;
import org.treetank.access.NodeReadTrx;
import org.treetank.access.NodeWriteTrx;
import org.treetank.access.conf.ResourceConfiguration;
import org.treetank.access.conf.SessionConfiguration;
import org.treetank.access.conf.StandardSettings;
import org.treetank.api.IBucketWriteTrx;
import org.treetank.api.IDataFactory;
import org.treetank.api.IMetaEntryFactory;
import org.treetank.api.INodeReadTrx;
import org.treetank.api.INodeWriteTrx;
import org.treetank.api.ISession;
import org.treetank.api.IStorage;
import org.treetank.data.NodeMetaPageFactory;
import org.treetank.data.TreeNodeFactory;
import org.treetank.exception.TTException;
import org.treetank.io.IBackend;
import org.treetank.revisioning.IRevisioning;
import org.treetank.service.jaxrx.util.RESTResponseHelper;
import org.treetank.service.jaxrx.util.RESTXMLShredder;
import org.treetank.service.jaxrx.util.RestXPathProcessor;
import org.treetank.service.jaxrx.util.WorkerHelper;
import org.treetank.service.xml.serialize.XMLSerializer;
import org.treetank.service.xml.shredder.EShredderInsert;
import org.treetank.service.xml.shredder.XMLShredder;
import org.treetank.service.xml.xpath.XPathAxis;

public class DatabaseRepresentation {
    private final IStorage mDatabase;
    private static final transient String beginResult = "<jaxrx:result xmlns:jaxrx=\"http://jaxrx.org/\">";
    private static final transient String endResult = "</jaxrx:result>";
    private static final transient String YESSTRING = "yes";
    private static final IDataFactory NODEFACTORY = new TreeNodeFactory();
    private static final IMetaEntryFactory METAFAC = new NodeMetaPageFactory();
    private final IBackend.IBackendFactory mStorageFac;
    private final IRevisioning mRevision;

    public DatabaseRepresentation(IStorage pDatabase, IBackend.IBackendFactory pStorageFac, IRevisioning pRevision) throws TTException {
        this.mDatabase = pDatabase;
        this.mStorageFac = pStorageFac;
        this.mRevision = pRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createResource(InputStream inputStream, String resourceName) throws JaxRxException {
        String string = resourceName;
        synchronized (string) {
            if (inputStream == null) {
                throw new JaxRxException(400, "Bad user request");
            }
            try {
                this.shred(inputStream, resourceName);
            }
            catch (TTException exce) {
                throw new JaxRxException((Exception)((Object)exce));
            }
        }
    }

    public StreamingOutput getResource(final String resourceName, final Map<QueryParameter, String> queryParams) throws JaxRxException {
        StreamingOutput streamingOutput = new StreamingOutput(){

            public void write(OutputStream output) throws IOException, JaxRxException {
                String revision = (String)queryParams.get((Object)QueryParameter.REVISION);
                String wrap = (String)queryParams.get((Object)QueryParameter.WRAP);
                String nodeId = (String)queryParams.get((Object)QueryParameter.OUTPUT);
                boolean wrapResult = wrap == null ? false : wrap.equalsIgnoreCase(DatabaseRepresentation.YESSTRING);
                boolean nodeid = nodeId == null ? false : nodeId.equalsIgnoreCase(DatabaseRepresentation.YESSTRING);
                try {
                    if (revision == null) {
                        DatabaseRepresentation.this.serialize(resourceName, null, nodeid, output, wrapResult);
                    } else {
                        Pattern pattern = Pattern.compile("[0-9]+[-]{1}[1-9]+");
                        Matcher matcher = pattern.matcher(revision);
                        if (matcher.matches()) {
                            DatabaseRepresentation.this.getModificHistory(resourceName, revision, nodeid, output, wrapResult);
                        } else {
                            DatabaseRepresentation.this.serialize(resourceName, Long.valueOf(revision), nodeid, output, wrapResult);
                        }
                    }
                }
                catch (NumberFormatException exce) {
                    throw new JaxRxException(400, exce.getMessage());
                }
                catch (TTException exce) {
                    throw new JaxRxException((Exception)((Object)exce));
                }
            }
        };
        return streamingOutput;
    }

    public StreamingOutput performQueryOnResource(final String resource, final String query, final Map<QueryParameter, String> otherParams) {
        StreamingOutput streamingOutput = new StreamingOutput(){

            public void write(OutputStream output) throws IOException, JaxRxException {
                String revision = (String)otherParams.get((Object)QueryParameter.REVISION);
                String wrap = (String)otherParams.get((Object)QueryParameter.WRAP);
                String nodeId = (String)otherParams.get((Object)QueryParameter.OUTPUT);
                boolean wrapResult = wrap == null ? true : wrap.equalsIgnoreCase(DatabaseRepresentation.YESSTRING);
                boolean nodeid = nodeId == null ? false : nodeId.equalsIgnoreCase(DatabaseRepresentation.YESSTRING);
                Long rev = revision == null ? null : Long.valueOf(revision);
                RestXPathProcessor xpathProcessor = new RestXPathProcessor(DatabaseRepresentation.this.mDatabase);
                try {
                    xpathProcessor.getXpathResource(resource, query, nodeid, rev, output, wrapResult);
                }
                catch (TTException exce) {
                    throw new JaxRxException((Exception)((Object)exce));
                }
            }
        };
        return streamingOutput;
    }

    public StreamingOutput getResourcesNames() throws JaxRxException {
        return RESTResponseHelper.buildResponseOfDomLR(this.mDatabase, this.mStorageFac, this.mRevision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(InputStream input, String resource) throws JaxRxException {
        String string = resource;
        synchronized (string) {
            try {
                this.shred(input, resource);
            }
            catch (TTException exce) {
                throw new JaxRxException((Exception)((Object)exce));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteResource(String resourceName) throws WebApplicationException {
        String string = resourceName;
        synchronized (string) {
            try {
                this.mDatabase.truncateResource(new SessionConfiguration(resourceName, null));
            }
            catch (TTException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
    }

    public final boolean shred(InputStream xmlInput, String resource) throws TTException {
        boolean allOk;
        NodeWriteTrx wtx = null;
        IBucketWriteTrx pWtx = null;
        ISession session = null;
        boolean abort = false;
        try {
            if (!this.mDatabase.existsResource(resource)) {
                Properties properties = StandardSettings.getProps((String)this.mDatabase.getLocation().getAbsolutePath(), (String)resource);
                this.mDatabase.createResource(new ResourceConfiguration(properties, this.mStorageFac, this.mRevision, NODEFACTORY, METAFAC));
            }
            session = this.mDatabase.getSession(new SessionConfiguration(resource, StandardSettings.KEY));
            pWtx = session.beginBucketWtx();
            wtx = new NodeWriteTrx(session, pWtx, NodeWriteTrx.HashKind.Rolling);
            wtx.moveTo(0L);
            XMLShredder shredder = new XMLShredder((INodeWriteTrx)wtx, RESTXMLShredder.createReader(xmlInput), EShredderInsert.ADDASFIRSTCHILD);
            shredder.call();
            allOk = true;
        }
        catch (Exception exce) {
            try {
                abort = true;
                throw new JaxRxException(exce);
            }
            catch (Throwable throwable) {
                WorkerHelper.closeWTX(abort, wtx, session);
                throw throwable;
            }
        }
        WorkerHelper.closeWTX(abort, (INodeWriteTrx)wtx, session);
        return allOk;
    }

    private final OutputStream serialize(String resource, Long revision, boolean nodeid, OutputStream output, boolean wrapResult) throws IOException, JaxRxException, TTException {
        if (this.mDatabase.existsResource(resource)) {
            try {
                if (wrapResult) {
                    output.write(beginResult.getBytes());
                    this.serializIt(resource, revision, output, nodeid);
                    output.write(endResult.getBytes());
                }
                this.serializIt(resource, revision, output, nodeid);
            }
            catch (Exception exce) {
                throw new JaxRxException(exce);
            }
        } else {
            throw new JaxRxException(404, "Not found");
        }
        return output;
    }

    public long getLastRevision(String resourceName) throws JaxRxException, TTException {
        long lastRevision;
        if (this.mDatabase.existsResource(resourceName)) {
            try (ISession session = null;){
                session = this.mDatabase.getSession(new SessionConfiguration(resourceName, StandardSettings.KEY));
                lastRevision = session.getMostRecentVersion();
            }
        } else {
            throw new JaxRxException(404, "Resource not found");
        }
        return lastRevision;
    }

    public OutputStream getModificHistory(String resourceName, String revisionRange, boolean nodeid, OutputStream output, boolean wrap) throws JaxRxException, TTException {
        ISession session;
        NodeReadTrx rtx;
        block15: {
            block14: {
                long revision2;
                StringTokenizer tokenizer = new StringTokenizer(revisionRange, "-");
                long revision1 = Long.valueOf(tokenizer.nextToken());
                if (revision1 >= (revision2 = Long.valueOf(tokenizer.nextToken()).longValue()) || revision2 > this.getLastRevision(resourceName)) break block14;
                long maxRestidRev1 = 0L;
                long maxRestidRev2 = 0L;
                XPathAxis axis = null;
                rtx = null;
                session = null;
                LinkedList<Long> modificRestids = new LinkedList<Long>();
                LinkedList<Long> restIdsRev1 = new LinkedList<Long>();
                try {
                    session = this.mDatabase.getSession(new SessionConfiguration(resourceName, StandardSettings.KEY));
                    rtx = new NodeReadTrx(session.beginBucketRtx(revision1));
                    axis = new XPathAxis((INodeReadTrx)rtx, ".//*");
                    while (axis.hasNext()) {
                        if (rtx.getNode().getDataKey() > maxRestidRev1) {
                            maxRestidRev1 = rtx.getNode().getDataKey();
                        }
                        restIdsRev1.add(rtx.getNode().getDataKey());
                    }
                    rtx.moveTo(0L);
                    rtx.close();
                    rtx = new NodeReadTrx(session.beginBucketRtx(revision2));
                    axis = new XPathAxis((INodeReadTrx)rtx, ".//*");
                    while (axis.hasNext()) {
                        Long nodeKey = rtx.getNode().getDataKey();
                        if (nodeKey > maxRestidRev2) {
                            maxRestidRev2 = rtx.getNode().getDataKey();
                        }
                        if (nodeKey > maxRestidRev1) {
                            modificRestids.add(nodeKey);
                        }
                        restIdsRev1.remove(nodeKey);
                    }
                    rtx.moveTo(0L);
                    rtx.close();
                    rtx = new NodeReadTrx(session.beginBucketRtx(revision1));
                    LinkedList<Long> restIdsRev1New = new LinkedList<Long>();
                    for (Long nodeKey : restIdsRev1) {
                        rtx.moveTo(nodeKey.longValue());
                        long parentKey = rtx.getNode().getParentKey();
                        if (restIdsRev1.contains(parentKey)) continue;
                        restIdsRev1New.add(nodeKey);
                    }
                    rtx.moveTo(0L);
                    rtx.close();
                    if (wrap) {
                        output.write(beginResult.getBytes());
                    }
                    rtx = new NodeReadTrx(session.beginBucketRtx(revision2));
                    for (Long nodeKey : modificRestids) {
                        rtx.moveTo(nodeKey.longValue());
                        WorkerHelper.serializeXML(session, output, false, nodeid, nodeKey, revision2).call();
                    }
                    rtx.moveTo(0L);
                    rtx.close();
                    rtx = new NodeReadTrx(session.beginBucketRtx(revision1));
                    for (Long nodeKey : restIdsRev1New) {
                        rtx.moveTo(nodeKey.longValue());
                        WorkerHelper.serializeXML(session, output, false, nodeid, nodeKey, revision1).call();
                    }
                    if (wrap) {
                        output.write(endResult.getBytes());
                    }
                    rtx.moveTo(0L);
                }
                catch (Exception globExcep) {
                    try {
                        throw new JaxRxException(globExcep);
                    }
                    catch (Throwable throwable) {
                        WorkerHelper.closeRTX(rtx, session);
                        throw throwable;
                    }
                }
                break block15;
            }
            throw new JaxRxException(400, "Bad user request");
        }
        WorkerHelper.closeRTX((INodeReadTrx)rtx, session);
        return output;
    }

    private void serializIt(String resource, Long revision, OutputStream output, boolean nodeid) throws JaxRxException, TTException {
        ISession session = null;
        try {
            session = this.mDatabase.getSession(new SessionConfiguration(resource, StandardSettings.KEY));
            XMLSerializer.XMLSerializerBuilder builder = revision == null ? new XMLSerializer.XMLSerializerBuilder(session, output, new long[0]) : new XMLSerializer.XMLSerializerBuilder(session, output, new long[]{revision});
            builder.setREST(nodeid);
            builder.setID(nodeid);
            builder.setDeclaration(false);
            XMLSerializer serializer = builder.build();
            serializer.call();
        }
        catch (Exception exce) {
            try {
                throw new JaxRxException(exce);
            }
            catch (Throwable throwable) {
                WorkerHelper.closeRTX(null, session);
                throw throwable;
            }
        }
        WorkerHelper.closeRTX(null, session);
    }

    public void revertToRevision(String resourceName, long backToRevision) throws JaxRxException, TTException {
        ISession session = null;
        NodeWriteTrx wtx = null;
        boolean abort = false;
        try {
            session = this.mDatabase.getSession(new SessionConfiguration(resourceName, StandardSettings.KEY));
            wtx = new NodeWriteTrx(session, session.beginBucketWtx(), NodeWriteTrx.HashKind.Rolling);
            wtx.revertTo(backToRevision);
            wtx.commit();
        }
        catch (TTException exce) {
            try {
                abort = true;
                throw new JaxRxException((Exception)((Object)exce));
            }
            catch (Throwable throwable) {
                WorkerHelper.closeWTX(abort, wtx, session);
                throw throwable;
            }
        }
        WorkerHelper.closeWTX(abort, (INodeWriteTrx)wtx, session);
    }
}

