/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.service.jaxrx.implementation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.ws.rs.core.StreamingOutput;
import org.jaxrx.core.JaxRxException;
import org.jaxrx.core.QueryParameter;
import org.treetank.access.NodeReadTrx;
import org.treetank.access.NodeWriteTrx;
import org.treetank.access.conf.SessionConfiguration;
import org.treetank.access.conf.StandardSettings;
import org.treetank.api.INodeReadTrx;
import org.treetank.api.INodeWriteTrx;
import org.treetank.api.ISession;
import org.treetank.api.IStorage;
import org.treetank.data.interfaces.ITreeStructData;
import org.treetank.exception.TTException;
import org.treetank.service.jaxrx.enums.EIdAccessType;
import org.treetank.service.jaxrx.util.RestXPathProcessor;
import org.treetank.service.jaxrx.util.WorkerHelper;
import org.treetank.service.xml.serialize.XMLSerializer;
import org.treetank.service.xml.serialize.XMLSerializerProperties;
import org.treetank.service.xml.shredder.EShredderInsert;

public class NodeIdRepresentation {
    private static final transient byte[] BEGINRESULT = "<jaxrx:result xmlns:jaxrx=\"http://jaxrx.org/\">".getBytes();
    private static final transient byte[] ENDRESULT = "</jaxrx:result>".getBytes();
    private static final transient String NOTFOUND = "Node id not found";
    private static final transient String YESSTRING = "yes";
    private final IStorage mDatabase;

    public NodeIdRepresentation(IStorage pDatabase) {
        this.mDatabase = pDatabase;
    }

    public StreamingOutput getResource(final String resourceName, final long nodeId, final Map<QueryParameter, String> queryParams) throws JaxRxException {
        StreamingOutput sOutput = new StreamingOutput(){

            public void write(OutputStream output) throws IOException, JaxRxException {
                String revision = (String)queryParams.get((Object)QueryParameter.REVISION);
                String wrap = (String)queryParams.get((Object)QueryParameter.WRAP);
                String doNodeId = (String)queryParams.get((Object)QueryParameter.OUTPUT);
                boolean wrapResult = wrap == null ? false : wrap.equalsIgnoreCase(NodeIdRepresentation.YESSTRING);
                boolean nodeid = doNodeId == null ? false : doNodeId.equalsIgnoreCase(NodeIdRepresentation.YESSTRING);
                Long rev = revision == null ? null : Long.valueOf(revision);
                NodeIdRepresentation.this.serialize(resourceName, nodeId, rev, nodeid, output, wrapResult);
            }
        };
        return sOutput;
    }

    public StreamingOutput getResourceByAT(final String resourceName, final long nodeId, final Map<QueryParameter, String> queryParams, final EIdAccessType accessType) throws JaxRxException {
        StreamingOutput sOutput = new StreamingOutput(){

            public void write(OutputStream output) throws IOException, JaxRxException {
                String revision = (String)queryParams.get((Object)QueryParameter.REVISION);
                String wrap = (String)queryParams.get((Object)QueryParameter.WRAP);
                String doNodeId = (String)queryParams.get((Object)QueryParameter.OUTPUT);
                boolean wrapResult = wrap == null ? false : wrap.equalsIgnoreCase(NodeIdRepresentation.YESSTRING);
                boolean nodeid = doNodeId == null ? false : doNodeId.equalsIgnoreCase(NodeIdRepresentation.YESSTRING);
                Long rev = revision == null ? null : Long.valueOf(revision);
                NodeIdRepresentation.this.serializeAT(resourceName, nodeId, rev, nodeid, output, wrapResult, accessType);
            }
        };
        return sOutput;
    }

    public StreamingOutput performQueryOnResource(final String resourceName, final long nodeId, final String query, final Map<QueryParameter, String> queryParams) {
        StreamingOutput sOutput = new StreamingOutput(){

            public void write(OutputStream output) throws IOException, JaxRxException {
                String revision = (String)queryParams.get((Object)QueryParameter.REVISION);
                String wrap = (String)queryParams.get((Object)QueryParameter.WRAP);
                String doNodeId = (String)queryParams.get((Object)QueryParameter.OUTPUT);
                boolean wrapResult = wrap == null ? true : wrap.equalsIgnoreCase(NodeIdRepresentation.YESSTRING);
                boolean nodeid = doNodeId == null ? false : doNodeId.equalsIgnoreCase(NodeIdRepresentation.YESSTRING);
                Long rev = revision == null ? null : Long.valueOf(revision);
                RestXPathProcessor xpathProcessor = new RestXPathProcessor(NodeIdRepresentation.this.mDatabase);
                try {
                    xpathProcessor.getXpathResource(resourceName, nodeId, query, nodeid, rev, output, wrapResult);
                }
                catch (TTException exce) {
                    throw new JaxRxException((Exception)((Object)exce));
                }
            }
        };
        return sOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteResource(String resourceName, long nodeId) throws JaxRxException {
        String string = resourceName;
        synchronized (string) {
            ISession session = null;
            NodeWriteTrx wtx = null;
            boolean abort = false;
            if (!this.mDatabase.existsResource(resourceName)) throw new JaxRxException(404, "DB not found");
            try {
                session = this.mDatabase.getSession(new SessionConfiguration(resourceName, StandardSettings.KEY));
                wtx = new NodeWriteTrx(session, session.beginBucketWtx(), NodeWriteTrx.HashKind.Rolling);
                if (!wtx.moveTo(nodeId)) throw new JaxRxException(404, NOTFOUND);
                wtx.remove();
                wtx.commit();
            }
            catch (TTException exce) {
                try {
                    abort = true;
                    throw new JaxRxException((Exception)((Object)exce));
                }
                catch (Throwable throwable) {
                    try {
                        WorkerHelper.closeWTX(abort, wtx, session);
                        throw throwable;
                    }
                    catch (TTException exce2) {
                        throw new JaxRxException((Exception)((Object)exce2));
                    }
                }
            }
            try {
                WorkerHelper.closeWTX(abort, (INodeWriteTrx)wtx, session);
            }
            catch (TTException exce) {
                throw new JaxRxException((Exception)((Object)exce));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modifyResource(String resourceName, long nodeId, InputStream newValue) throws JaxRxException {
        String string = resourceName;
        synchronized (string) {
            ISession session = null;
            NodeWriteTrx wtx = null;
            boolean abort = false;
            if (!this.mDatabase.existsResource(resourceName)) throw new JaxRxException(404, "Requested resource not found");
            try {
                session = this.mDatabase.getSession(new SessionConfiguration(resourceName, StandardSettings.KEY));
                wtx = new NodeWriteTrx(session, session.beginBucketWtx(), NodeWriteTrx.HashKind.Rolling);
                if (!wtx.moveTo(nodeId)) throw new JaxRxException(404, NOTFOUND);
                long parentKey = wtx.getNode().getParentKey();
                wtx.remove();
                wtx.moveTo(parentKey);
                WorkerHelper.shredInputStream((INodeWriteTrx)wtx, newValue, EShredderInsert.ADDASFIRSTCHILD);
            }
            catch (TTException exc) {
                try {
                    abort = true;
                    throw new JaxRxException((Exception)((Object)exc));
                }
                catch (Throwable throwable) {
                    try {
                        WorkerHelper.closeWTX(abort, wtx, session);
                        throw throwable;
                    }
                    catch (TTException exce) {
                        throw new JaxRxException((Exception)((Object)exce));
                    }
                }
            }
            try {
                WorkerHelper.closeWTX(abort, (INodeWriteTrx)wtx, session);
            }
            catch (TTException exce) {
                throw new JaxRxException((Exception)((Object)exce));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addSubResource(String resourceName, long nodeId, InputStream input, EIdAccessType type) throws JaxRxException {
        ISession session = null;
        NodeWriteTrx wtx = null;
        String string = resourceName;
        synchronized (string) {
            boolean abort;
            block16: {
                if (!this.mDatabase.existsResource(resourceName)) return;
                abort = false;
                try {
                    session = this.mDatabase.getSession(new SessionConfiguration(resourceName, StandardSettings.KEY));
                    wtx = new NodeWriteTrx(session, session.beginBucketWtx(), NodeWriteTrx.HashKind.Rolling);
                    boolean exist = wtx.moveTo(nodeId);
                    if (!exist) throw new JaxRxException(404, NOTFOUND);
                    if (type == EIdAccessType.FIRSTCHILD) {
                        WorkerHelper.shredInputStream((INodeWriteTrx)wtx, input, EShredderInsert.ADDASFIRSTCHILD);
                        break block16;
                    }
                    if (type == EIdAccessType.RIGHTSIBLING) {
                        WorkerHelper.shredInputStream((INodeWriteTrx)wtx, input, EShredderInsert.ADDASRIGHTSIBLING);
                        break block16;
                    }
                    if (type == EIdAccessType.LASTCHILD) {
                        if (!wtx.moveTo(((ITreeStructData)wtx.getNode()).getFirstChildKey())) throw new JaxRxException(404, NOTFOUND);
                        long last = wtx.getNode().getDataKey();
                        while (wtx.moveTo(((ITreeStructData)wtx.getNode()).getRightSiblingKey())) {
                            last = wtx.getNode().getDataKey();
                        }
                        wtx.moveTo(last);
                        WorkerHelper.shredInputStream((INodeWriteTrx)wtx, input, EShredderInsert.ADDASRIGHTSIBLING);
                        break block16;
                    }
                    if (type == EIdAccessType.LEFTSIBLING && wtx.moveTo(((ITreeStructData)wtx.getNode()).getLeftSiblingKey())) {
                        WorkerHelper.shredInputStream((INodeWriteTrx)wtx, input, EShredderInsert.ADDASRIGHTSIBLING);
                    }
                }
                catch (JaxRxException exce) {
                    try {
                        abort = true;
                        throw exce;
                        catch (Exception exce2) {
                            abort = true;
                            throw new JaxRxException(exce2);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            WorkerHelper.closeWTX(abort, wtx, session);
                            throw throwable;
                        }
                        catch (TTException exce3) {
                            throw new JaxRxException((Exception)((Object)exce3));
                        }
                    }
                }
            }
            try {
                WorkerHelper.closeWTX(abort, (INodeWriteTrx)wtx, session);
            }
            catch (TTException exce) {
                throw new JaxRxException((Exception)((Object)exce));
            }
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void serialize(String resource, long nodeId, Long revision, boolean doNodeId, OutputStream output, boolean wrapResult) {
        if (!this.mDatabase.existsResource(resource)) throw new JaxRxException(404, "Resource does not exist");
        ISession session = null;
        try {
            XMLSerializerProperties props;
            session = this.mDatabase.getSession(new SessionConfiguration(resource, StandardSettings.KEY));
            if (wrapResult) {
                output.write(BEGINRESULT);
                props = new XMLSerializerProperties();
                XMLSerializer.XMLSerializerBuilder builder = new XMLSerializer.XMLSerializerBuilder(session, nodeId, output, props, new long[0]);
                builder.setREST(doNodeId);
                builder.setID(doNodeId);
                builder.setDeclaration(false);
                XMLSerializer serializer = builder.build();
                serializer.call();
                output.write(ENDRESULT);
            } else {
                props = new XMLSerializerProperties();
                XMLSerializer.XMLSerializerBuilder builder = new XMLSerializer.XMLSerializerBuilder(session, nodeId, output, props, new long[0]);
                builder.setREST(doNodeId);
                builder.setID(doNodeId);
                builder.setDeclaration(false);
                XMLSerializer serializer = builder.build();
                serializer.call();
            }
        }
        catch (TTException ttExcep) {
            try {
                throw new JaxRxException((Exception)((Object)ttExcep));
                catch (IOException ioExcep) {
                    throw new JaxRxException(ioExcep);
                }
                catch (Exception globExcep) {
                    if (!(globExcep instanceof JaxRxException)) throw new JaxRxException(globExcep);
                    throw (JaxRxException)((Object)globExcep);
                }
            }
            catch (Throwable throwable) {
                try {
                    WorkerHelper.closeRTX(null, session);
                    throw throwable;
                }
                catch (TTException exce) {
                    throw new JaxRxException((Exception)((Object)exce));
                }
            }
        }
        try {
            WorkerHelper.closeRTX(null, session);
            return;
        }
        catch (TTException exce) {
            throw new JaxRxException((Exception)((Object)exce));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void serializeAT(String resource, long nodeId, Long revision, boolean doNodeId, OutputStream output, boolean wrapResult, EIdAccessType accessType) {
        if (!this.mDatabase.existsResource(resource)) throw new JaxRxException(404, "Resource does not exist");
        ISession session = null;
        NodeReadTrx rtx = null;
        try {
            XMLSerializerProperties props;
            session = this.mDatabase.getSession(new SessionConfiguration(resource, StandardSettings.KEY));
            rtx = revision == null ? new NodeReadTrx(session.beginBucketRtx(session.getMostRecentVersion())) : new NodeReadTrx(session.beginBucketRtx(revision.longValue()));
            if (!rtx.moveTo(nodeId)) throw new JaxRxException(404, NOTFOUND);
            switch (accessType) {
                case FIRSTCHILD: {
                    if (rtx.moveTo(((ITreeStructData)rtx.getNode()).getFirstChildKey())) break;
                    throw new JaxRxException(404, NOTFOUND);
                }
                case LASTCHILD: {
                    if (!rtx.moveTo(((ITreeStructData)rtx.getNode()).getFirstChildKey())) throw new JaxRxException(404, NOTFOUND);
                    long last = rtx.getNode().getDataKey();
                    while (rtx.moveTo(((ITreeStructData)rtx.getNode()).getRightSiblingKey())) {
                        last = rtx.getNode().getDataKey();
                    }
                    rtx.moveTo(last);
                    break;
                }
                case RIGHTSIBLING: {
                    if (rtx.moveTo(((ITreeStructData)rtx.getNode()).getRightSiblingKey())) break;
                    throw new JaxRxException(404, NOTFOUND);
                }
                case LEFTSIBLING: {
                    if (rtx.moveTo(((ITreeStructData)rtx.getNode()).getLeftSiblingKey())) break;
                    throw new JaxRxException(404, NOTFOUND);
                }
            }
            if (wrapResult) {
                output.write(BEGINRESULT);
                props = new XMLSerializerProperties();
                XMLSerializer.XMLSerializerBuilder builder = new XMLSerializer.XMLSerializerBuilder(session, rtx.getNode().getDataKey(), output, props, new long[0]);
                builder.setREST(doNodeId);
                builder.setID(doNodeId);
                builder.setDeclaration(false);
                builder.setIndend(false);
                XMLSerializer serializer = builder.build();
                serializer.call();
                output.write(ENDRESULT);
            } else {
                props = new XMLSerializerProperties();
                XMLSerializer.XMLSerializerBuilder builder = new XMLSerializer.XMLSerializerBuilder(session, rtx.getNode().getDataKey(), output, props, new long[0]);
                builder.setREST(doNodeId);
                builder.setID(doNodeId);
                builder.setDeclaration(false);
                builder.setIndend(false);
                XMLSerializer serializer = builder.build();
                serializer.call();
            }
        }
        catch (TTException ttExcep) {
            try {
                throw new JaxRxException((Exception)((Object)ttExcep));
                catch (IOException ioExcep) {
                    throw new JaxRxException(ioExcep);
                }
                catch (Exception globExcep) {
                    if (!(globExcep instanceof JaxRxException)) throw new JaxRxException(globExcep);
                    throw (JaxRxException)((Object)globExcep);
                }
            }
            catch (Throwable throwable) {
                try {
                    WorkerHelper.closeRTX(rtx, session);
                    throw throwable;
                }
                catch (TTException exce) {
                    throw new JaxRxException((Exception)((Object)exce));
                }
            }
        }
        try {
            WorkerHelper.closeRTX((INodeReadTrx)rtx, session);
            return;
        }
        catch (TTException exce) {
            throw new JaxRxException((Exception)((Object)exce));
        }
    }
}

