/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.service.jaxrx.implementation;

import com.google.common.io.Files;
import com.google.inject.Inject;
import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.StreamingOutput;
import org.jaxrx.JaxRx;
import org.jaxrx.core.JaxRxException;
import org.jaxrx.core.QueryParameter;
import org.jaxrx.core.ResourcePath;
import org.treetank.access.Storage;
import org.treetank.access.conf.StorageConfiguration;
import org.treetank.api.IStorage;
import org.treetank.exception.TTException;
import org.treetank.io.IBackend;
import org.treetank.revisioning.IRevisioning;
import org.treetank.service.jaxrx.enums.EIdAccessType;
import org.treetank.service.jaxrx.implementation.DatabaseRepresentation;
import org.treetank.service.jaxrx.implementation.NodeIdRepresentation;
import org.treetank.service.jaxrx.util.WorkerHelper;

public final class TreeTankMediator
implements JaxRx {
    private final transient DatabaseRepresentation database;
    private final transient NodeIdRepresentation nodeIdResource;
    @Inject
    private IBackend.IBackendFactory mStorageFac;
    @Inject
    private IRevisioning mRevision;
    private static final transient String NOTALLOWEDSTRING = "Method not allowed on this resource request";

    public TreeTankMediator() throws TTException {
        File pStoragePath = Files.createTempDir();
        if (!Storage.existsStorage((File)pStoragePath)) {
            Storage.createStorage((StorageConfiguration)new StorageConfiguration(pStoragePath));
        }
        IStorage db = Storage.openStorage((File)pStoragePath);
        this.database = new DatabaseRepresentation(db, this.mStorageFac, this.mRevision);
        this.nodeIdResource = new NodeIdRepresentation(db);
    }

    @Override
    public String add(InputStream input, ResourcePath path) throws JaxRxException {
        int depth = path.getDepth();
        if (depth == 1) {
            this.database.add(input, path.getResourcePath());
        } else if (depth == 2) {
            this.nodeIdResource.addSubResource(path.getResource(0), Long.valueOf(path.getResource(1)), input, EIdAccessType.FIRSTCHILD);
        } else if (depth == 3) {
            EIdAccessType accessType = WorkerHelper.getInstance().validateAccessType(path.getResource(2));
            this.nodeIdResource.addSubResource(path.getResource(0), Long.valueOf(path.getResource(1)), input, accessType);
        }
        return null;
    }

    @Override
    public StreamingOutput command(String command, ResourcePath path) throws JaxRxException {
        String revision;
        if (command.equalsIgnoreCase("revert") && path.getDepth() == 1 && (revision = path.getValue(QueryParameter.REVISION)) != null) {
            try {
                this.database.revertToRevision(path.getResourcePath(), Long.valueOf(revision));
                return null;
            }
            catch (NumberFormatException exce) {
                throw new JaxRxException(400, "False value for REVISION paramter: " + exce.getMessage());
            }
            catch (TTException exce) {
                throw new JaxRxException((Exception)((Object)exce));
            }
        }
        throw new JaxRxException(403, "Currently only 'revert' is accepted as COMMAND query parameter in a POST request. In GET requests we do not support COMMAND query parameters");
    }

    @Override
    public String update(InputStream input, ResourcePath path) throws JaxRxException {
        int depth = path.getDepth();
        if (depth == 1) {
            this.database.createResource(input, path.getResourcePath());
        } else if (depth == 2) {
            this.nodeIdResource.modifyResource(path.getResource(0), Long.valueOf(path.getResource(1)), input);
        } else {
            throw new JaxRxException(405, NOTALLOWEDSTRING);
        }
        return null;
    }

    @Override
    public String delete(ResourcePath path) throws JaxRxException {
        int depth = path.getDepth();
        switch (depth) {
            case 1: {
                this.database.deleteResource(path.getResourcePath());
                break;
            }
            case 2: {
                this.nodeIdResource.deleteResource(path.getResource(0), Long.valueOf(path.getResource(1)));
                break;
            }
            default: {
                throw new JaxRxException(405, NOTALLOWEDSTRING);
            }
        }
        return null;
    }

    @Override
    public StreamingOutput get(ResourcePath path) throws JaxRxException {
        StreamingOutput response;
        int depth = path.getDepth();
        switch (depth) {
            case 0: {
                response = this.database.getResourcesNames();
                break;
            }
            case 1: {
                response = this.database.getResource(path.getResourcePath(), path.getQueryParameter());
                break;
            }
            case 2: {
                response = this.nodeIdResource.getResource(path.getResource(0), Long.valueOf(path.getResource(1)), path.getQueryParameter());
                break;
            }
            case 3: {
                EIdAccessType accessType = WorkerHelper.getInstance().validateAccessType(path.getResource(2));
                if (accessType == null) {
                    throw new JaxRxException(400, "The access type: " + path.getResource(2) + " is not supported.");
                }
                response = this.nodeIdResource.getResourceByAT(path.getResource(0), Long.valueOf(path.getResource(1)), path.getQueryParameter(), accessType);
                break;
            }
            default: {
                throw new JaxRxException(405, NOTALLOWEDSTRING);
            }
        }
        return response;
    }

    @Override
    public Set<QueryParameter> getParameters() {
        HashSet<QueryParameter> availParams = new HashSet<QueryParameter>();
        availParams.add(QueryParameter.OUTPUT);
        availParams.add(QueryParameter.QUERY);
        availParams.add(QueryParameter.REVISION);
        availParams.add(QueryParameter.WRAP);
        availParams.add(QueryParameter.COMMAND);
        return availParams;
    }

    @Override
    public StreamingOutput query(String query, ResourcePath path) throws JaxRxException {
        StreamingOutput response;
        int depth = path.getDepth();
        switch (depth) {
            case 1: {
                response = this.database.performQueryOnResource(path.getResourcePath(), query, path.getQueryParameter());
                break;
            }
            case 2: {
                response = this.nodeIdResource.performQueryOnResource(path.getResource(0), Long.valueOf(path.getResource(1)), query, path.getQueryParameter());
                break;
            }
            default: {
                throw new JaxRxException(405, NOTALLOWEDSTRING);
            }
        }
        return response;
    }

    @Override
    public StreamingOutput run(String file, ResourcePath path) throws JaxRxException {
        throw new JaxRxException(403, "Currently no applicable RUN query parameter in a GET request within TreeTank.");
    }
}

