/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.service.jaxrx.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.treetank.api.IStorage;
import org.treetank.exception.TTException;
import org.treetank.io.IBackend;
import org.treetank.revisioning.IRevisioning;
import org.treetank.service.jaxrx.implementation.DatabaseRepresentation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class RESTResponseHelper {
    private RESTResponseHelper() {
    }

    private static Document createSurroundingXMLResp() throws ParserConfigurationException {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        return document;
    }

    private static Element createResultElement(Document document) {
        Element ttResponse = document.createElementNS("http://jaxrx.org/", "result");
        ttResponse.setPrefix("jaxrx");
        return ttResponse;
    }

    private static List<Element> createCollectionElementDBs(IStorage pDatabase, Document document, IBackend.IBackendFactory pStorageFac, IRevisioning pRevision) throws WebApplicationException, TTException {
        ArrayList<Element> collectionsEls = new ArrayList<Element>();
        for (String res : pDatabase.listResources()) {
            Element elRes = document.createElement("resource");
            elRes.setAttribute("name", res);
            DatabaseRepresentation dbWorker = new DatabaseRepresentation(pDatabase, pStorageFac, pRevision);
            String lastRevision = Long.toString(dbWorker.getLastRevision(res.toString()));
            elRes.setAttribute("lastRevision", lastRevision);
            collectionsEls.add(elRes);
        }
        return collectionsEls;
    }

    public static StreamingOutput buildResponseOfDomLR(final IStorage pDatabase, final IBackend.IBackendFactory pStorageFac, final IRevisioning pRevision) {
        StreamingOutput sOutput = new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                try {
                    List collections;
                    Document document = RESTResponseHelper.createSurroundingXMLResp();
                    Element resElement = RESTResponseHelper.createResultElement(document);
                    try {
                        collections = RESTResponseHelper.createCollectionElementDBs(pDatabase, document, pStorageFac, pRevision);
                    }
                    catch (TTException exce) {
                        throw new WebApplicationException((Throwable)exce);
                    }
                    for (Element resource : collections) {
                        resElement.appendChild(resource);
                    }
                    document.appendChild(resElement);
                    DOMSource domSource = new DOMSource(document);
                    StreamResult streamResult = new StreamResult(output);
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.transform(domSource, streamResult);
                }
                catch (ParserConfigurationException exce) {
                    throw new WebApplicationException((Throwable)exce);
                }
                catch (TransformerConfigurationException exce) {
                    throw new WebApplicationException((Throwable)exce);
                }
                catch (TransformerFactoryConfigurationError exce) {
                    throw new WebApplicationException((Throwable)exce);
                }
                catch (TransformerException exce) {
                    throw new WebApplicationException((Throwable)exce);
                }
            }
        };
        return sOutput;
    }
}

