/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.service.jaxrx.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.treetank.access.NodeReadTrx;
import org.treetank.access.conf.SessionConfiguration;
import org.treetank.access.conf.StandardSettings;
import org.treetank.api.INodeReadTrx;
import org.treetank.api.ISession;
import org.treetank.api.IStorage;
import org.treetank.exception.TTException;
import org.treetank.service.jaxrx.util.WorkerHelper;
import org.treetank.service.xml.xpath.XPathAxis;

public class RestXPathProcessor {
    private static transient String beginResult = "<jaxrx:result xmlns:jaxrx=\"http://jaxrx.org/\">";
    private static transient String endResult = "</jaxrx:result>";
    private final IStorage mDatabase;

    public RestXPathProcessor(IStorage pDatabase) {
        this.mDatabase = pDatabase;
    }

    public OutputStream getXpathResource(String resourceName, String xpath, boolean nodeid, Long revision, OutputStream output, boolean wrapResult) throws IOException, TTException {
        String qQuery = xpath;
        if (xpath.charAt(0) == '/') {
            qQuery = ".".concat(xpath);
        }
        if (this.mDatabase.existsResource(resourceName)) {
            if (wrapResult) {
                output.write(beginResult.getBytes());
                this.doXPathRes(resourceName, revision, output, nodeid, qQuery);
                output.write(endResult.getBytes());
            } else {
                this.doXPathRes(resourceName, revision, output, nodeid, qQuery);
            }
        } else {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return output;
    }

    public void getXpathResource(String resourceName, long rId, String query, boolean doNodeId, Long doRevision, OutputStream output, boolean doWrap) throws TTException {
        block8: {
            String qQuery = query;
            if (query.charAt(0) == '/') {
                qQuery = ".".concat(query);
            }
            ISession session = null;
            NodeReadTrx rtx = null;
            try {
                if (!this.mDatabase.existsResource(resourceName)) break block8;
                session = this.mDatabase.getSession(new SessionConfiguration(resourceName, StandardSettings.KEY));
                rtx = doRevision == null ? new NodeReadTrx(session.beginBucketRtx(session.getMostRecentVersion())) : new NodeReadTrx(session.beginBucketRtx(doRevision.longValue()));
                boolean exist = rtx.moveTo(rId);
                if (exist) {
                    XPathAxis axis = new XPathAxis((INodeReadTrx)rtx, qQuery);
                    if (doWrap) {
                        output.write(beginResult.getBytes());
                        Iterator i$ = axis.iterator();
                        while (i$.hasNext()) {
                            long key = (Long)i$.next();
                            WorkerHelper.serializeXML(session, output, false, doNodeId, key, doRevision).call();
                        }
                        output.write(endResult.getBytes());
                    } else {
                        Iterator i$ = axis.iterator();
                        while (i$.hasNext()) {
                            long key = (Long)i$.next();
                            WorkerHelper.serializeXML(session, output, false, doNodeId, key, doRevision).call();
                        }
                    }
                    break block8;
                }
                throw new WebApplicationException(404);
            }
            catch (Exception globExcep) {
                throw new WebApplicationException((Throwable)globExcep, Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
    }

    private void doXPathRes(String resource, Long revision, OutputStream output, boolean nodeid, String xpath) throws TTException {
        ISession session = null;
        NodeReadTrx rtx = null;
        try {
            if (this.mDatabase.existsResource(resource)) {
                session = this.mDatabase.getSession(new SessionConfiguration(resource, StandardSettings.KEY));
                rtx = revision == null ? new NodeReadTrx(session.beginBucketRtx(session.getMostRecentVersion())) : new NodeReadTrx(session.beginBucketRtx(revision.longValue()));
                XPathAxis axis = new XPathAxis((INodeReadTrx)rtx, xpath);
                Iterator i$ = axis.iterator();
                while (i$.hasNext()) {
                    long key = (Long)i$.next();
                    WorkerHelper.serializeXML(session, output, false, nodeid, key, revision).call();
                }
            }
        }
        catch (Exception globExcep) {
            throw new WebApplicationException((Throwable)globExcep, Response.Status.INTERNAL_SERVER_ERROR);
        }
        finally {
            WorkerHelper.closeRTX(rtx, session);
        }
    }
}

