/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.service.jaxrx.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.treetank.api.INodeReadTrx;
import org.treetank.api.INodeWriteTrx;
import org.treetank.api.ISession;
import org.treetank.exception.TTException;
import org.treetank.service.jaxrx.enums.EIdAccessType;
import org.treetank.service.xml.serialize.XMLSerializer;
import org.treetank.service.xml.serialize.XMLSerializerProperties;
import org.treetank.service.xml.shredder.EShredderInsert;
import org.treetank.service.xml.shredder.XMLShredder;

public final class WorkerHelper {
    private final transient Map<String, EIdAccessType> typeList = new HashMap<String, EIdAccessType>();
    private static final transient WorkerHelper INSTANCE = new WorkerHelper();

    private WorkerHelper() {
        this.typeList.put("FIRSTCHILD()", EIdAccessType.FIRSTCHILD);
        this.typeList.put("LASTCHILD()", EIdAccessType.LASTCHILD);
        this.typeList.put("RIGHTSIBLING()", EIdAccessType.RIGHTSIBLING);
        this.typeList.put("LEFTSIBLING()", EIdAccessType.LEFTSIBLING);
    }

    public static void shredInputStream(INodeWriteTrx wtx, InputStream value, EShredderInsert child) {
        XMLEventReader parser;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.supportDTD", false);
        try {
            parser = factory.createXMLEventReader(value);
        }
        catch (XMLStreamException xmlse) {
            throw new WebApplicationException((Throwable)xmlse);
        }
        try {
            XMLShredder shredder = new XMLShredder(wtx, parser, child);
            shredder.call();
        }
        catch (Exception exce) {
            throw new WebApplicationException((Throwable)exce);
        }
    }

    public static XMLSerializer serializeXML(ISession session, OutputStream out, boolean serializeXMLDec, boolean serializeRest, Long revision) {
        XMLSerializer.XMLSerializerBuilder builder = revision == null ? new XMLSerializer.XMLSerializerBuilder(session, out, new long[0]) : new XMLSerializer.XMLSerializerBuilder(session, out, new long[]{revision});
        builder.setREST(serializeRest);
        builder.setID(serializeRest);
        builder.setDeclaration(serializeXMLDec);
        XMLSerializer serializer = builder.build();
        return serializer;
    }

    public static XMLSerializer serializeXML(ISession session, OutputStream out, boolean serializeXMLDec, boolean serializeRest, Long nodekey, Long revision) {
        XMLSerializerProperties props = new XMLSerializerProperties();
        XMLSerializer.XMLSerializerBuilder builder = revision == null && nodekey == null ? new XMLSerializer.XMLSerializerBuilder(session, out, new long[0]) : (revision != null && nodekey == null ? new XMLSerializer.XMLSerializerBuilder(session, out, new long[]{revision}) : (revision == null && nodekey != null ? new XMLSerializer.XMLSerializerBuilder(session, nodekey.longValue(), out, props, new long[0]) : new XMLSerializer.XMLSerializerBuilder(session, nodekey.longValue(), out, props, new long[]{revision})));
        builder.setREST(serializeRest);
        builder.setID(serializeRest);
        builder.setDeclaration(serializeXMLDec);
        builder.setIndend(false);
        XMLSerializer serializer = builder.build();
        return serializer;
    }

    public StringBuilder createStringBuilderObject() {
        return new StringBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeWTX(boolean abortTransaction, INodeWriteTrx wtx, ISession ses) throws TTException {
        ISession iSession = ses;
        synchronized (iSession) {
            if (abortTransaction) {
                wtx.abort();
            }
            ses.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeRTX(INodeReadTrx rtx, ISession ses) throws TTException {
        ISession iSession = ses;
        synchronized (iSession) {
            ses.close();
        }
    }

    public EIdAccessType validateAccessType(String accessType) {
        return this.typeList.get(accessType.toUpperCase(Locale.US));
    }

    public static WorkerHelper getInstance() {
        return INSTANCE;
    }
}

