/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.saxon.wrapper;

import java.io.File;
import java.util.Properties;
import javax.xml.stream.XMLEventReader;
import org.treetank.access.NodeWriteTrx;
import org.treetank.access.Storage;
import org.treetank.access.conf.ResourceConfiguration;
import org.treetank.access.conf.SessionConfiguration;
import org.treetank.access.conf.StandardSettings;
import org.treetank.access.conf.StorageConfiguration;
import org.treetank.api.INodeWriteTrx;
import org.treetank.api.ISession;
import org.treetank.api.IStorage;
import org.treetank.service.xml.shredder.EShredderInsert;
import org.treetank.service.xml.shredder.XMLShredder;
import org.treetank.testutil.CoreTestHelper;
import org.treetank.testutil.NodeElementTestHelper;

public final class SaxonHelper {
    private static final File BOOKSXML = new File("src" + File.separator + "test" + File.separator + "resources" + File.separator + "data" + File.separator + "my-books.xml");

    public static void createBookDB(ResourceConfiguration.IResourceConfigurationFactory resFac) throws Exception {
        CoreTestHelper.deleteEverything();
        StorageConfiguration dbConfig = new StorageConfiguration(CoreTestHelper.PATHS.PATH1.getFile());
        Storage.createStorage((StorageConfiguration)dbConfig);
        IStorage storage = Storage.openStorage((File)CoreTestHelper.PATHS.PATH1.getFile());
        Properties props = StandardSettings.getProps((String)CoreTestHelper.PATHS.PATH1.getFile().getAbsolutePath(), (String)"grave928134589762");
        storage.createResource(resFac.create(props));
        ISession session = storage.getSession(new SessionConfiguration("grave928134589762", StandardSettings.KEY));
        NodeWriteTrx wtx = new NodeWriteTrx(session, session.beginBucketWtx(), NodeWriteTrx.HashKind.Rolling);
        NodeElementTestHelper.createDocumentRootNode((INodeWriteTrx)wtx);
        XMLEventReader reader = XMLShredder.createFileReader((File)BOOKSXML);
        XMLShredder shredder = new XMLShredder((INodeWriteTrx)wtx, reader, EShredderInsert.ADDASFIRSTCHILD);
        shredder.call();
        wtx.close();
        session.close();
        storage.close();
    }
}

