/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.saxon.wrapper;

import com.google.inject.Inject;
import java.io.File;
import java.util.Properties;
import javax.xml.stream.XMLEventReader;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;
import org.treetank.access.NodeWriteTrx;
import org.treetank.access.Storage;
import org.treetank.access.conf.ResourceConfiguration;
import org.treetank.access.conf.SessionConfiguration;
import org.treetank.access.conf.StandardSettings;
import org.treetank.access.conf.StorageConfiguration;
import org.treetank.api.INodeWriteTrx;
import org.treetank.api.ISession;
import org.treetank.api.IStorage;
import org.treetank.exception.TTException;
import org.treetank.saxon.wrapper.DocumentWrapper;
import org.treetank.saxon.wrapper.NodeWrapper;
import org.treetank.service.xml.shredder.EShredderInsert;
import org.treetank.service.xml.shredder.XMLShredder;
import org.treetank.testutil.CoreTestHelper;
import org.treetank.testutil.Holder;
import org.treetank.testutil.ModuleFactory;
import org.treetank.testutil.NodeElementTestHelper;

@Guice(moduleFactory=ModuleFactory.class)
public class TestNodeWrapper {
    private Holder holder;
    @Inject
    private ResourceConfiguration.IResourceConfigurationFactory mResourceConfig;
    private ResourceConfiguration mResource;
    private transient NodeWrapper node;

    @BeforeMethod
    public void beforeMethod() throws TTException {
        CoreTestHelper.deleteEverything();
        CoreTestHelper.Holder holder = CoreTestHelper.Holder.generateStorage();
        Properties props = StandardSettings.getProps((String)CoreTestHelper.PATHS.PATH1.getFile().getAbsolutePath(), (String)"grave928134589762");
        this.mResource = this.mResourceConfig.create(props);
        NodeElementTestHelper.createTestDocument((ResourceConfiguration)this.mResource);
        this.holder = Holder.generateRtx((CoreTestHelper.Holder)holder, (ResourceConfiguration)this.mResource);
        Processor proc = new Processor(false);
        Configuration config = proc.getUnderlyingConfiguration();
        this.node = new DocumentWrapper(holder.getSession(), config).getNodeWrapper();
    }

    @AfterMethod
    public void afterMethod() throws TTException {
        CoreTestHelper.deleteEverything();
    }

    @Test
    public void testAtomize() throws Exception {
        Value value = this.node.atomize();
        AssertJUnit.assertEquals((boolean)true, (boolean)(value instanceof UntypedAtomicValue));
        AssertJUnit.assertEquals((String)"oops1foooops2baroops3", (String)value.getStringValue());
    }

    @Test
    public void testCompareOrder() throws XPathException, TTException {
        Processor proc = new Processor(false);
        Configuration config = proc.getUnderlyingConfiguration();
        DocumentWrapper node = new DocumentWrapper(this.holder.getSession(), config);
        NodeWrapper other = new NodeWrapper(new DocumentWrapper(this.holder.getSession(), config), 3L);
        AssertJUnit.assertEquals((int)-1, (int)node.compareOrder((NodeInfo)other));
        node = new NodeWrapper(new DocumentWrapper(this.holder.getSession(), config), 3L);
        other = new NodeWrapper(new DocumentWrapper(this.holder.getSession(), config), 0L);
        AssertJUnit.assertEquals((int)1, (int)node.compareOrder((NodeInfo)other));
        node = new NodeWrapper(new DocumentWrapper(this.holder.getSession(), config), 3L);
        other = new NodeWrapper(new DocumentWrapper(this.holder.getSession(), config), 3L);
        AssertJUnit.assertEquals((int)0, (int)node.compareOrder((NodeInfo)other));
    }

    @Test
    public void testGetAttributeValue() throws TTException {
        Processor proc = new Processor(false);
        this.node = new NodeWrapper(new DocumentWrapper(this.holder.getSession(), proc.getUnderlyingConfiguration()), 1L);
        AxisIterator iterator = this.node.iterateAxis((byte)2);
        NodeInfo attribute = iterator.next();
        this.node.getNamePool().allocate(attribute.getPrefix(), attribute.getURI(), attribute.getLocalPart());
        AssertJUnit.assertEquals((String)"j", (String)this.node.getAttributeValue(attribute.getFingerprint()));
    }

    @Test
    public void testGetBaseURI() throws Exception {
        File source = new File("src" + File.separator + "test" + File.separator + "resources" + File.separator + "data" + File.separator + "testBaseURI.xml");
        StorageConfiguration db2 = new StorageConfiguration(CoreTestHelper.PATHS.PATH2.getFile());
        Storage.createStorage((StorageConfiguration)db2);
        IStorage storage = Storage.openStorage((File)CoreTestHelper.PATHS.PATH2.getFile());
        Properties props = StandardSettings.getProps((String)CoreTestHelper.PATHS.PATH2.getFile().getAbsolutePath(), (String)"grave928134589762");
        storage.createResource(this.mResourceConfig.create(props));
        ISession session = storage.getSession(new SessionConfiguration("grave928134589762", StandardSettings.KEY));
        NodeWriteTrx wtx = new NodeWriteTrx(session, session.beginBucketWtx(), NodeWriteTrx.HashKind.Rolling);
        NodeElementTestHelper.createDocumentRootNode((INodeWriteTrx)wtx);
        XMLEventReader reader = XMLShredder.createFileReader((File)source);
        XMLShredder shredder = new XMLShredder((INodeWriteTrx)wtx, reader, EShredderInsert.ADDASFIRSTCHILD);
        shredder.call();
        wtx.close();
        Processor proc = new Processor(false);
        DocumentWrapper doc = new DocumentWrapper(session, proc.getUnderlyingConfiguration());
        doc.getNamePool().allocate("xml", "http://www.w3.org/XML/1998/namespace", "base");
        doc.getNamePool().allocate("", "", "baz");
        NameTest test = new NameTest(1, "", "baz", doc.getNamePool());
        AxisIterator iterator = doc.iterateAxis((byte)4, (NodeTest)test);
        NodeInfo baz = iterator.next();
        AssertJUnit.assertEquals((String)"http://example.org", (String)baz.getBaseURI());
        session.close();
        storage.close();
    }

    @Test
    public void testGetStringValueCS() {
        AssertJUnit.assertEquals((Object)"oops1foooops2baroops3", (Object)this.node.getStringValueCS());
        AxisIterator iterator = this.node.iterateAxis((byte)4);
        this.node = (NodeWrapper)iterator.next();
        AssertJUnit.assertEquals((Object)"oops1foooops2baroops3", (Object)this.node.getStringValueCS());
        NodeWrapper attrib = (NodeWrapper)this.node.iterateAxis((byte)2).next();
        AssertJUnit.assertEquals((Object)"j", (Object)attrib.getStringValueCS());
        NodeWrapper text = (NodeWrapper)this.node.iterateAxis((byte)3).next();
        AssertJUnit.assertEquals((Object)"oops1", (Object)text.getStringValueCS());
    }

    @Test
    public void testGetSiblingPosition() {
        AxisIterator iterator = this.node.iterateAxis((byte)4);
        this.node = (NodeWrapper)iterator.next();
        this.node = (NodeWrapper)iterator.next();
        AssertJUnit.assertEquals((int)0, (int)this.node.getSiblingPosition());
        this.node = (NodeWrapper)iterator.next();
        AssertJUnit.assertEquals((int)1, (int)this.node.getSiblingPosition());
        this.node = (NodeWrapper)iterator.next();
        AssertJUnit.assertEquals((int)0, (int)this.node.getSiblingPosition());
        this.node = (NodeWrapper)iterator.next();
        AssertJUnit.assertEquals((int)1, (int)this.node.getSiblingPosition());
        this.node = (NodeWrapper)iterator.next();
        AssertJUnit.assertEquals((int)2, (int)this.node.getSiblingPosition());
        this.node = (NodeWrapper)iterator.next();
        AssertJUnit.assertEquals((int)3, (int)this.node.getSiblingPosition());
        this.node = (NodeWrapper)iterator.next();
        AssertJUnit.assertEquals((int)0, (int)this.node.getSiblingPosition());
        this.node = (NodeWrapper)iterator.next();
        AssertJUnit.assertEquals((int)1, (int)this.node.getSiblingPosition());
        this.node = (NodeWrapper)iterator.next();
        AssertJUnit.assertEquals((int)4, (int)this.node.getSiblingPosition());
    }
}

