/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.saxon.wrapper;

import com.google.inject.Inject;
import java.util.Properties;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import org.custommonkey.xmlunit.XMLUnit;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;
import org.treetank.access.conf.ResourceConfiguration;
import org.treetank.access.conf.StandardSettings;
import org.treetank.exception.TTException;
import org.treetank.saxon.evaluator.XPathEvaluator;
import org.treetank.testutil.CoreTestHelper;
import org.treetank.testutil.Holder;
import org.treetank.testutil.ModuleFactory;
import org.treetank.testutil.NodeElementTestHelper;

@Guice(moduleFactory=ModuleFactory.class)
public final class TestNodeWrapperS9ApiXPath {
    private Holder holder;
    @Inject
    private ResourceConfiguration.IResourceConfigurationFactory mResourceConfig;

    @BeforeMethod
    public void beforeMethod() throws TTException {
        CoreTestHelper.deleteEverything();
        CoreTestHelper.Holder holder = CoreTestHelper.Holder.generateStorage();
        Properties props = StandardSettings.getProps((String)CoreTestHelper.PATHS.PATH1.getFile().getAbsolutePath(), (String)"grave928134589762");
        ResourceConfiguration mResource = this.mResourceConfig.create(props);
        NodeElementTestHelper.createTestDocument((ResourceConfiguration)mResource);
        this.holder = Holder.generateRtx((CoreTestHelper.Holder)holder, (ResourceConfiguration)mResource);
        XMLUnit.setIgnoreWhitespace((boolean)true);
    }

    @AfterMethod
    public void afterMethod() throws TTException {
        CoreTestHelper.deleteEverything();
    }

    @Test
    public void testB1() throws Exception {
        XPathSelector selector = new XPathEvaluator("//b[1]", this.holder.getSession()).call();
        StringBuilder strBuilder = new StringBuilder();
        for (XdmItem item : selector) {
            strBuilder.append(item.toString());
        }
        AssertJUnit.assertEquals((String)"expected pieces to be similar", (String)"<b xmlns:p=\"ns\">foo<c xmlns:p=\"ns\"/>\n</b>", (String)strBuilder.toString());
    }

    @Test
    public void testB1String() throws Exception {
        XPathSelector selector = new XPathEvaluator("//b[1]/text()", this.holder.getSession()).call();
        StringBuilder strBuilder = new StringBuilder();
        for (XdmItem item : selector) {
            strBuilder.append(item.toString());
        }
        AssertJUnit.assertEquals((String)"foo", (String)strBuilder.toString());
    }

    @Test
    public void testB2() throws Exception {
        XPathSelector selector = new XPathEvaluator("//b[2]", this.holder.getSession()).call();
        StringBuilder strBuilder = new StringBuilder();
        for (XdmItem item : selector) {
            strBuilder.append(item.toString());
        }
        AssertJUnit.assertEquals((String)"expected pieces to be similar", (String)"<b xmlns:p=\"ns\" p:x=\"y\">\n   <c xmlns:p=\"ns\"/>bar</b>", (String)strBuilder.toString());
    }

    @Test
    public void testB2Text() throws Exception {
        XPathSelector selector = new XPathEvaluator("//b[2]/text()", this.holder.getSession()).call();
        StringBuilder strBuilder = new StringBuilder();
        for (XdmItem item : selector) {
            strBuilder.append(item.toString());
        }
        AssertJUnit.assertEquals((String)"bar", (String)strBuilder.toString());
    }

    @Test
    public void testB() throws Exception {
        XPathSelector selector = new XPathEvaluator("//b", this.holder.getSession()).call();
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("<result>");
        for (XdmItem item : selector) {
            strBuilder.append(item.toString());
        }
        strBuilder.append("</result>");
        AssertJUnit.assertEquals((String)"expected pieces to be similar", (String)"<result><b xmlns:p=\"ns\">foo<c xmlns:p=\"ns\"/>\n</b><b xmlns:p=\"ns\" p:x=\"y\">\n   <c xmlns:p=\"ns\"/>bar</b></result>", (String)strBuilder.toString());
    }

    @Test
    public void testCountB() throws Exception {
        XPathSelector selector = new XPathEvaluator("count(//b)", this.holder.getSession()).call();
        StringBuilder sb = new StringBuilder();
        for (XdmItem item : selector) {
            sb.append(item.getStringValue());
        }
        AssertJUnit.assertEquals((String)"2", (String)sb.toString());
    }
}

