/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.saxon.wrapper;

import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;
import org.treetank.access.conf.ResourceConfiguration;
import org.treetank.access.conf.StandardSettings;
import org.treetank.exception.TTException;
import org.treetank.saxon.evaluator.XQueryEvaluatorOutputStream;
import org.treetank.saxon.wrapper.SaxonHelper;
import org.treetank.testutil.CoreTestHelper;
import org.treetank.testutil.ModuleFactory;

@Guice(moduleFactory=ModuleFactory.class)
public final class TestNodeWrapperS9ApiXQueryOutputStream {
    private CoreTestHelper.Holder holder;
    @Inject
    private ResourceConfiguration.IResourceConfigurationFactory mResourceConfig;

    @BeforeMethod
    public void beforeMethod() throws Exception {
        CoreTestHelper.deleteEverything();
        this.holder = CoreTestHelper.Holder.generateStorage();
        Properties props = StandardSettings.getProps((String)CoreTestHelper.PATHS.PATH1.getFile().getAbsolutePath(), (String)"grave928134589762");
        SaxonHelper.createBookDB(this.mResourceConfig);
        ResourceConfiguration mResource = this.mResourceConfig.create(props);
        CoreTestHelper.Holder.generateSession((CoreTestHelper.Holder)this.holder, (ResourceConfiguration)mResource);
    }

    @AfterMethod
    public void afterMethod() throws TTException {
        this.holder.getSession().close();
        this.holder.getStorage().close();
        CoreTestHelper.deleteEverything();
    }

    @Test
    public void testWhereBooks() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new XQueryEvaluatorOutputStream("for $x in /bookstore/book where $x/price>30 return $x/title", this.holder.getSession(), (OutputStream)out).call();
        String result = ((Object)out).toString();
        AssertJUnit.assertEquals((String)"<title lang=\"en\">XQuery Kick Start</title><title lang=\"en\">Learning XML</title>", (String)result);
    }

    @Test
    public void testOrderByBooks() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new XQueryEvaluatorOutputStream("for $x in /bookstore/book where $x/price>30 order by $x/title return $x/title", this.holder.getSession(), (OutputStream)out).call();
        String result = ((Object)out).toString();
        AssertJUnit.assertEquals((String)"<title lang=\"en\">Learning XML</title><title lang=\"en\">XQuery Kick Start</title>", (String)result);
    }

    @Test
    public void testFLOWR() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new XQueryEvaluatorOutputStream("for $x in /bookstore/book let $y := $x/price where $y>30 order by $x/title return $x/title", this.holder.getSession(), (OutputStream)out).call();
        String result = ((Object)out).toString();
        AssertJUnit.assertEquals((String)"<title lang=\"en\">Learning XML</title><title lang=\"en\">XQuery Kick Start</title>", (String)result);
    }
}

