/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.saxon.wrapper;

import com.google.inject.Inject;
import java.util.Properties;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;
import org.treetank.access.conf.ResourceConfiguration;
import org.treetank.access.conf.StandardSettings;
import org.treetank.exception.TTException;
import org.treetank.saxon.evaluator.XQueryEvaluatorSAXHandler;
import org.treetank.saxon.wrapper.SaxonHelper;
import org.treetank.testutil.CoreTestHelper;
import org.treetank.testutil.ModuleFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

@Guice(moduleFactory=ModuleFactory.class)
public class TestNodeWrapperS9ApiXQuerySAXHandler {
    private CoreTestHelper.Holder holder;
    @Inject
    private ResourceConfiguration.IResourceConfigurationFactory mResourceConfig;

    @BeforeMethod
    public void beforeMethod() throws Exception {
        CoreTestHelper.deleteEverything();
        this.holder = CoreTestHelper.Holder.generateStorage();
        Properties props = StandardSettings.getProps((String)CoreTestHelper.PATHS.PATH1.getFile().getAbsolutePath(), (String)"grave928134589762");
        SaxonHelper.createBookDB(this.mResourceConfig);
        ResourceConfiguration mResource = this.mResourceConfig.create(props);
        CoreTestHelper.Holder.generateSession((CoreTestHelper.Holder)this.holder, (ResourceConfiguration)mResource);
    }

    @AfterMethod
    public void afterMethod() throws TTException {
        this.holder.getSession().close();
        this.holder.getStorage().close();
        CoreTestHelper.deleteEverything();
    }

    @Test
    public void testWhereBooks() throws Exception {
        final StringBuilder strBuilder = new StringBuilder();
        XMLFilterImpl contHandler = new XMLFilterImpl(){

            @Override
            public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                strBuilder.append("<" + localName);
                for (int i = 0; i < atts.getLength(); ++i) {
                    strBuilder.append(" " + atts.getQName(i));
                    strBuilder.append("=\"" + atts.getValue(i) + "\"");
                }
                strBuilder.append(">");
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                strBuilder.append("</" + localName + ">");
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                for (int i = start; i < start + length; ++i) {
                    strBuilder.append(ch[i]);
                }
            }
        };
        new XQueryEvaluatorSAXHandler("for $x in /bookstore/book where $x/price>30 return $x/title", this.holder.getSession(), (ContentHandler)contHandler).call();
        AssertJUnit.assertEquals((String)strBuilder.toString(), (String)"<title lang=\"en\">XQuery Kick Start</title><title lang=\"en\">Learning XML</title>");
    }
}

