/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.saxon.wrapper;

import com.google.inject.Inject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import javax.xml.stream.XMLEventReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.custommonkey.xmlunit.XMLUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.treetank.access.NodeWriteTrx;
import org.treetank.access.Storage;
import org.treetank.access.conf.ResourceConfiguration;
import org.treetank.access.conf.SessionConfiguration;
import org.treetank.access.conf.StandardSettings;
import org.treetank.access.conf.StorageConfiguration;
import org.treetank.api.INodeWriteTrx;
import org.treetank.api.ISession;
import org.treetank.api.IStorage;
import org.treetank.exception.TTException;
import org.treetank.service.xml.shredder.EShredderInsert;
import org.treetank.service.xml.shredder.XMLShredder;
import org.treetank.testutil.CoreTestHelper;
import org.treetank.testutil.ModuleFactory;
import org.treetank.testutil.NodeElementTestHelper;

@Guice(moduleFactory=ModuleFactory.class)
public final class TestNodeWrapperS9ApiXSLT {
    private static final File STYLESHEET = new File("src" + File.separator + "test" + File.separator + "resources" + File.separator + "styles" + File.separator + "books.xsl");
    private static final File BOOKS = new File("src" + File.separator + "test" + File.separator + "resources" + File.separator + "data" + File.separator + "books.xml");
    private CoreTestHelper.Holder holder;
    @Inject
    private ResourceConfiguration.IResourceConfigurationFactory mResourceConfig;

    @BeforeMethod
    public void setUp() throws Exception {
        CoreTestHelper.deleteEverything();
        this.holder = CoreTestHelper.Holder.generateStorage();
        StorageConfiguration dbConfig = new StorageConfiguration(CoreTestHelper.PATHS.PATH1.getFile());
        Storage.createStorage((StorageConfiguration)dbConfig);
        IStorage databaseBooks = Storage.openStorage((File)CoreTestHelper.PATHS.PATH1.getFile());
        Properties props = StandardSettings.getProps((String)CoreTestHelper.PATHS.PATH1.getFile().getAbsolutePath(), (String)"grave928134589762");
        ResourceConfiguration resConfig = this.mResourceConfig.create(props);
        databaseBooks.createResource(resConfig);
        ISession session = databaseBooks.getSession(new SessionConfiguration("grave928134589762", StandardSettings.KEY));
        NodeWriteTrx wtx = new NodeWriteTrx(session, session.beginBucketWtx(), NodeWriteTrx.HashKind.Rolling);
        NodeElementTestHelper.createDocumentRootNode((INodeWriteTrx)wtx);
        XMLEventReader reader = XMLShredder.createFileReader((File)BOOKS);
        XMLShredder shredder = new XMLShredder((INodeWriteTrx)wtx, reader, EShredderInsert.ADDASFIRSTCHILD);
        shredder.call();
        wtx.close();
        session.close();
        databaseBooks.close();
        CoreTestHelper.Holder.generateSession((CoreTestHelper.Holder)this.holder, (ResourceConfiguration)resConfig);
        this.saxonTransform(BOOKS, STYLESHEET);
        XMLUnit.setIgnoreWhitespace((boolean)true);
    }

    @AfterMethod
    public void tearDown() throws TTException {
        CoreTestHelper.closeEverything();
        CoreTestHelper.deleteEverything();
    }

    private void saxonTransform(File xml, File stylesheet) throws SaxonApiException {
        Processor proc = new Processor(false);
        XsltCompiler comp = proc.newXsltCompiler();
        XsltExecutable exp = comp.compile((Source)new StreamSource(stylesheet));
        XdmNode source = proc.newDocumentBuilder().build((Source)new StreamSource(xml));
        Serializer out = new Serializer();
        out.setOutputProperty(Serializer.Property.METHOD, "xml");
        out.setOutputProperty(Serializer.Property.INDENT, "yes");
        out.setOutputFile(new File(CoreTestHelper.PATHS.PATH1.getFile(), "books1.html"));
        XsltTransformer trans = exp.load();
        trans.setInitialContextNode(source);
        trans.setDestination((Destination)out);
        trans.transform();
    }

    private StringBuilder readFile() throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(new File(CoreTestHelper.PATHS.PATH1.getFile(), "books1.html")));
        StringBuilder sBuilder = new StringBuilder();
        String line = in.readLine();
        while (line != null) {
            sBuilder.append(line + "\n");
            line = in.readLine();
        }
        sBuilder.replace(sBuilder.length() - 1, sBuilder.length(), "");
        in.close();
        return sBuilder;
    }
}

