/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.saxon.wrapper;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import net.sf.saxon.Configuration;
import net.sf.saxon.xpath.XPathFactoryImpl;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;
import org.treetank.access.NodeReadTrx;
import org.treetank.access.conf.ResourceConfiguration;
import org.treetank.access.conf.StandardSettings;
import org.treetank.data.interfaces.ITreeData;
import org.treetank.exception.TTException;
import org.treetank.saxon.wrapper.DocumentWrapper;
import org.treetank.testutil.CoreTestHelper;
import org.treetank.testutil.Holder;
import org.treetank.testutil.ModuleFactory;
import org.treetank.testutil.NodeElementTestHelper;

@Guice(moduleFactory=ModuleFactory.class)
public final class TestNodeWrapperXPath {
    private Holder holder;
    @Inject
    private ResourceConfiguration.IResourceConfigurationFactory mResourceConfig;
    private static transient XPath xpe;
    private static transient Configuration config;

    @BeforeMethod
    public void setUp() throws TTException, XPathFactoryConfigurationException {
        CoreTestHelper.deleteEverything();
        CoreTestHelper.Holder holder = CoreTestHelper.Holder.generateStorage();
        Properties props = StandardSettings.getProps((String)CoreTestHelper.PATHS.PATH1.getFile().getAbsolutePath(), (String)"grave928134589762");
        ResourceConfiguration resource = this.mResourceConfig.create(props);
        NodeElementTestHelper.createTestDocument((ResourceConfiguration)resource);
        this.holder = Holder.generateRtx((CoreTestHelper.Holder)holder, (ResourceConfiguration)resource);
        System.setProperty("javax.xml.xpath.XPathFactory:http://saxon.sf.net/jaxp/xpath/om", "net.sf.saxon.xpath.XPathFactoryImpl");
        XPathFactory xpf = XPathFactory.newInstance("http://saxon.sf.net/jaxp/xpath/om");
        xpe = xpf.newXPath();
        config = ((XPathFactoryImpl)xpf).getConfiguration();
    }

    @AfterMethod
    public void tearDown() throws Exception {
        this.holder.getSession().close();
        CoreTestHelper.deleteEverything();
    }

    @Test(enabled=false)
    private void test(String[] expressions, Object doc, Object[] expectedResults, Object[] result, QName[] xpathConstants, boolean[] namespaces, Object namespace) throws Exception {
        for (int i = 0; i < expectedResults.length; ++i) {
            if (namespaces[i]) {
                xpe.setNamespaceContext((NamespaceContext)namespace);
            }
            XPathExpression findLine = xpe.compile(expressions[i]);
            if (xpathConstants[i].equals(XPathConstants.NODESET)) {
                result[i] = findLine.evaluate(doc, xpathConstants[i]);
            } else if (xpathConstants[i].equals(XPathConstants.STRING)) {
                result[i] = (String)findLine.evaluate(doc, xpathConstants[i]);
            } else if (xpathConstants[i].equals(XPathConstants.NUMBER)) {
                result[i] = Double.parseDouble(findLine.evaluate(doc, xpathConstants[i]).toString());
            } else {
                throw new IllegalStateException("Unknown XPathConstant!");
            }
            AssertJUnit.assertNotNull((Object)result);
            if (xpathConstants[i].equals(XPathConstants.NODESET)) {
                ArrayList test = (ArrayList)result[i];
                String res = (String)expectedResults[i];
                String[] expRes = res.split(" ");
                for (int j = 0; j < test.size(); ++j) {
                    ITreeData item = (ITreeData)test.get(j);
                    this.holder.getNRtx().moveTo(item.getDataKey());
                    QName qName = this.holder.getNRtx().getQNameOfCurrentNode();
                    if (this.holder.getNRtx().getNode().getKind() == 1) {
                        AssertJUnit.assertEquals((String)expRes[j], (String)(qName.getPrefix() + ":" + qName.getLocalPart()));
                        continue;
                    }
                    if (this.holder.getNRtx().getNode().getKind() != 3) continue;
                    AssertJUnit.assertEquals((String)expRes[j], (String)this.holder.getNRtx().getValueOfCurrentNode());
                }
                continue;
            }
            AssertJUnit.assertEquals((Object)expectedResults[i], (Object)result[i]);
        }
    }

    @Test
    public void testExample() throws Exception {
        String[] expressions = new String[]{"count(//b)", "count(//p:a)", "//p:a/@i", "//p:a/@p:i", "//b[1]/text()", "//b[2]", "//b[1]", "//b[2]/text()", "//p:a/text()"};
        DocumentWrapper doc = new DocumentWrapper(this.holder.getSession(), config);
        Object[] expectedResults = new Object[]{2.0, 1.0, "j", "", "foo", "bar", "foo", "bar", "oops1 oops2 oops3"};
        Object[] result = new Object[]{"", "", "", 0.0, "", "", "", "", ""};
        QName[] xpathConstants = new QName[]{XPathConstants.NUMBER, XPathConstants.NUMBER, XPathConstants.STRING, XPathConstants.STRING, XPathConstants.STRING, XPathConstants.STRING, XPathConstants.STRING, XPathConstants.STRING, XPathConstants.NODESET};
        boolean[] namespaces = new boolean[]{false, true, true, false, false, false, false, false, true};
        this.test(expressions, doc, expectedResults, result, xpathConstants, namespaces, new DocNamespaceContext());
    }

    @Test
    public void testElementBCount() throws Exception {
        XPathExpression findLine = xpe.compile("count(//b)");
        DocumentWrapper doc = new DocumentWrapper(this.holder.getSession(), config);
        double result = Double.parseDouble(findLine.evaluate(doc, XPathConstants.NUMBER).toString());
        AssertJUnit.assertNotNull((Object)result);
        AssertJUnit.assertEquals((double)2.0, (double)result, (double)0.0);
    }

    @Test
    public void testElementACount() throws Exception {
        XPathExpression findLine = xpe.compile("count(//a)");
        DocumentWrapper doc = new DocumentWrapper(this.holder.getSession(), config);
        double result = Double.parseDouble(findLine.evaluate(doc, XPathConstants.NUMBER).toString());
        AssertJUnit.assertNotNull((Object)result);
        AssertJUnit.assertEquals((double)0.0, (double)result, (double)0.0);
    }

    @Test
    public void testNamespaceElementCount() throws Exception {
        xpe.setNamespaceContext(new DocNamespaceContext());
        XPathExpression findLine = xpe.compile("count(//p:a)");
        DocumentWrapper doc = new DocumentWrapper(this.holder.getSession(), config);
        double result = Double.parseDouble(findLine.evaluate(doc, XPathConstants.NUMBER).toString());
        AssertJUnit.assertNotNull((Object)result);
        AssertJUnit.assertEquals((double)1.0, (double)result, (double)0.0);
    }

    @Test
    public void testAttributeCount() throws Exception {
        xpe.setNamespaceContext(new DocNamespaceContext());
        XPathExpression findLine = xpe.compile("count(//p:a/@i)");
        DocumentWrapper doc = new DocumentWrapper(this.holder.getSession(), config);
        double result = Double.parseDouble(findLine.evaluate(doc, XPathConstants.NUMBER).toString());
        AssertJUnit.assertNotNull((Object)result);
        AssertJUnit.assertEquals((double)1.0, (double)result, (double)0.0);
    }

    @Test
    public void testNamespaceAttributeCount() throws Exception {
        xpe.setNamespaceContext(new DocNamespaceContext());
        XPathExpression findLine = xpe.compile("count(//p:a/@p:i)");
        DocumentWrapper doc = new DocumentWrapper(this.holder.getSession(), config);
        double result = Double.parseDouble(findLine.evaluate(doc, XPathConstants.NUMBER).toString());
        AssertJUnit.assertNotNull((Object)result);
        AssertJUnit.assertEquals((double)0.0, (double)result, (double)0.0);
    }

    @Test
    public void testAttributeValue() throws Exception {
        xpe.setNamespaceContext(new DocNamespaceContext());
        XPathExpression findLine = xpe.compile("//p:a/@i");
        DocumentWrapper doc = new DocumentWrapper(this.holder.getSession(), config);
        String result = findLine.evaluate(doc, XPathConstants.STRING).toString();
        AssertJUnit.assertNotNull((Object)result);
        AssertJUnit.assertEquals((String)"j", (String)result);
    }

    @Test
    public void testNamespaceAttributeValue() throws Exception {
        xpe.setNamespaceContext(new DocNamespaceContext());
        XPathExpression findLine = xpe.compile("//p:a/@p:i");
        DocumentWrapper doc = new DocumentWrapper(this.holder.getSession(), config);
        String result = findLine.evaluate(doc, XPathConstants.STRING).toString();
        AssertJUnit.assertNotNull((Object)result);
        AssertJUnit.assertEquals((String)"", (String)result);
    }

    @Test
    public void testText() throws Exception {
        XPathExpression findLine = xpe.compile("//b[1]/text()");
        DocumentWrapper doc = new DocumentWrapper(this.holder.getSession(), config);
        String result = (String)findLine.evaluate(doc, XPathConstants.STRING);
        AssertJUnit.assertNotNull((Object)result);
        AssertJUnit.assertEquals((String)"foo", (String)result);
    }

    @Test
    public void testText1() throws Exception {
        xpe.setNamespaceContext(new DocNamespaceContext());
        XPathExpression findLine = xpe.compile("//p:a[1]/text()[1]");
        DocumentWrapper doc = new DocumentWrapper(this.holder.getSession(), config);
        String result = (String)findLine.evaluate(doc, XPathConstants.STRING);
        AssertJUnit.assertNotNull((Object)result);
        AssertJUnit.assertEquals((String)"oops1", (String)result);
    }

    @Test
    public void testDefaultNamespaceText1() throws Exception {
        xpe.setNamespaceContext(new DocNamespaceContext());
        XPathExpression findLine = xpe.compile("//p:a/text()[1]");
        DocumentWrapper doc = new DocumentWrapper(this.holder.getSession(), config);
        String result = (String)findLine.evaluate(doc, XPathConstants.STRING);
        AssertJUnit.assertNotNull((Object)result);
        AssertJUnit.assertEquals((String)"oops1", (String)result);
    }

    @Test
    public void testDefaultNamespaceText2() throws Exception {
        xpe.setNamespaceContext(new DocNamespaceContext());
        XPathExpression findLine = xpe.compile("//p:a/text()[2]");
        DocumentWrapper doc = new DocumentWrapper(this.holder.getSession(), config);
        String result = (String)findLine.evaluate(doc, XPathConstants.STRING);
        AssertJUnit.assertNotNull((Object)result);
        AssertJUnit.assertEquals((String)"oops2", (String)result);
    }

    @Test
    public void testDefaultNamespaceText3() throws Exception {
        xpe.setNamespaceContext(new DocNamespaceContext());
        XPathExpression findLine = xpe.compile("//p:a/text()[3]");
        DocumentWrapper doc = new DocumentWrapper(this.holder.getSession(), config);
        String result = (String)findLine.evaluate(doc, XPathConstants.STRING);
        AssertJUnit.assertNotNull((Object)result);
        AssertJUnit.assertEquals((String)"oops3", (String)result);
    }

    @Test
    public void testDefaultNamespaceTextAll() throws Exception {
        xpe.setNamespaceContext(new DocNamespaceContext());
        XPathExpression findLine = xpe.compile("//p:a/text()");
        DocumentWrapper doc = new DocumentWrapper(this.holder.getSession(), config);
        ArrayList result = (ArrayList)findLine.evaluate(doc, XPathConstants.NODESET);
        AssertJUnit.assertNotNull((Object)result);
        NodeReadTrx rtx = new NodeReadTrx(this.holder.getSession().beginBucketRtx(this.holder.getSession().getMostRecentVersion()));
        rtx.moveTo(((ITreeData)result.get(0)).getDataKey());
        AssertJUnit.assertEquals((String)"oops1", (String)rtx.getValueOfCurrentNode());
        rtx.moveTo(((ITreeData)result.get(1)).getDataKey());
        AssertJUnit.assertEquals((String)"oops2", (String)rtx.getValueOfCurrentNode());
        rtx.moveTo(((ITreeData)result.get(2)).getDataKey());
        AssertJUnit.assertEquals((String)"oops3", (String)rtx.getValueOfCurrentNode());
        rtx.close();
    }

    @Test
    public void testB1() throws Exception {
        xpe.setNamespaceContext(new DocNamespaceContext());
        XPathExpression findLine = xpe.compile("//b[1]");
        DocumentWrapper doc = new DocumentWrapper(this.holder.getSession(), config);
        String result = (String)findLine.evaluate(doc, XPathConstants.STRING);
        AssertJUnit.assertNotNull((Object)result);
        AssertJUnit.assertEquals((String)"foo", (String)result);
    }

    @Test
    public void testB2() throws Exception {
        xpe.setNamespaceContext(new DocNamespaceContext());
        XPathExpression findLine = xpe.compile("//b[2]");
        DocumentWrapper doc = new DocumentWrapper(this.holder.getSession(), config);
        String result = (String)findLine.evaluate(doc, XPathConstants.STRING);
        AssertJUnit.assertNotNull((Object)result);
        AssertJUnit.assertEquals((String)"bar", (String)result);
    }

    @Test
    public void testBAll() throws Exception {
        xpe.setNamespaceContext(new DocNamespaceContext());
        XPathExpression findLine = xpe.compile("//b");
        DocumentWrapper doc = new DocumentWrapper(this.holder.getSession(), config);
        ArrayList result = (ArrayList)findLine.evaluate(doc, XPathConstants.NODESET);
        AssertJUnit.assertNotNull((Object)result);
        AssertJUnit.assertEquals((long)5L, (long)((ITreeData)result.get(0)).getDataKey());
        AssertJUnit.assertEquals((long)9L, (long)((ITreeData)result.get(1)).getDataKey());
        NodeReadTrx rtx = new NodeReadTrx(this.holder.getSession().beginBucketRtx(this.holder.getSession().getMostRecentVersion()));
        rtx.moveTo(((ITreeData)result.get(0)).getDataKey());
        AssertJUnit.assertEquals((String)"b", (String)rtx.getQNameOfCurrentNode().getLocalPart());
        rtx.moveTo(((ITreeData)result.get(1)).getDataKey());
        AssertJUnit.assertEquals((String)"b", (String)rtx.getQNameOfCurrentNode().getLocalPart());
    }

    static class DocNamespaceContext
    implements NamespaceContext {
        DocNamespaceContext() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException("Prefix may not be null!");
            }
            if (prefix == "") {
                return "";
            }
            if (prefix == "xml") {
                return "http://www.w3.org/XML/1998/namespace";
            }
            if (prefix == "xmlns") {
                return "http://www.w3.org/2000/xmlns/";
            }
            if ("p".equals(prefix)) {
                return "ns";
            }
            return "";
        }

        @Override
        public String getPrefix(String namespace) {
            if (namespace == null) {
                throw new IllegalArgumentException("Namespace may not be null!");
            }
            if ("http://www.w3.org/XML/1998/namespace".equals(namespace)) {
                return "xml";
            }
            if ("http://www.w3.org/2000/xmlns/".equals(namespace)) {
                return "xmlns";
            }
            if (namespace.equals("ns")) {
                return "p";
            }
            return null;
        }

        @Override
        public Iterator<String> getPrefixes(String namespace) {
            throw new UnsupportedOperationException("Currently not needed by the test document!");
        }
    }
}

