/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.saxon.evaluator;

import java.util.concurrent.Callable;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.treetank.api.ISession;
import org.treetank.saxon.wrapper.DocumentWrapper;

public final class XPathEvaluator
implements Callable<XPathSelector> {
    private final transient String mExpression;
    private final transient ISession mSession;
    private static final Logger LOGGER = LoggerFactory.getLogger(XPathEvaluator.class);

    public XPathEvaluator(String paramExpression, ISession paramSession) {
        this.mExpression = paramExpression;
        this.mSession = paramSession;
    }

    @Override
    public XPathSelector call() throws Exception {
        Processor proc = new Processor(false);
        Configuration config = proc.getUnderlyingConfiguration();
        DocumentWrapper doc = new DocumentWrapper(this.mSession, config);
        XPathCompiler xpath = proc.newXPathCompiler();
        DocumentBuilder builder = proc.newDocumentBuilder();
        XPathSelector selector = null;
        try {
            XdmNode booksDoc = builder.build((Source)((Object)doc));
            selector = xpath.compile(this.mExpression).load();
            selector.setContextItem((XdmItem)booksDoc);
        }
        catch (SaxonApiException e) {
            LOGGER.error("Saxon Exception: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        return selector;
    }
}

