/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.saxon.evaluator;

import java.util.concurrent.Callable;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.treetank.api.ISession;
import org.treetank.saxon.wrapper.DocumentWrapper;

public final class XQueryEvaluator
implements Callable<XdmValue> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XQueryEvaluator.class);
    private final transient String mExpression;
    private final transient ISession mSession;

    public XQueryEvaluator(String paramExpression, ISession paramSession) {
        this.mExpression = paramExpression;
        this.mSession = paramSession;
    }

    @Override
    public XdmValue call() throws Exception {
        XdmValue value = null;
        try {
            Processor proc = new Processor(false);
            Configuration config = proc.getUnderlyingConfiguration();
            DocumentWrapper doc = new DocumentWrapper(this.mSession, config);
            XQueryCompiler comp = proc.newXQueryCompiler();
            XQueryExecutable exp = comp.compile(this.mExpression);
            net.sf.saxon.s9api.XQueryEvaluator exe = exp.load();
            exe.setSource((Source)((Object)doc));
            value = exe.evaluate();
        }
        catch (SaxonApiException e) {
            LOGGER.error("Saxon Exception: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        return value;
    }
}

