/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.saxon.evaluator;

import java.io.OutputStream;
import java.util.concurrent.Callable;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XQueryExecutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.treetank.api.ISession;
import org.treetank.saxon.wrapper.DocumentWrapper;

public final class XQueryEvaluatorOutputStream
implements Callable<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XQueryEvaluatorOutputStream.class);
    private final transient String mExpression;
    private final transient ISession mSession;
    private final transient OutputStream mOut;
    private transient Serializer mSerializer;

    public XQueryEvaluatorOutputStream(String paramExpression, ISession paramSession, OutputStream paramOut) {
        this(paramExpression, paramSession, paramOut, null);
    }

    public XQueryEvaluatorOutputStream(String paramExpression, ISession paramSession, OutputStream paramOut, Serializer paramSerializer) {
        this.mExpression = paramExpression;
        this.mSession = paramSession;
        this.mOut = paramOut;
        this.mSerializer = paramSerializer;
    }

    @Override
    public Void call() throws Exception {
        try {
            Processor proc = new Processor(false);
            Configuration config = proc.getUnderlyingConfiguration();
            DocumentWrapper doc = new DocumentWrapper(this.mSession, config);
            XQueryCompiler comp = proc.newXQueryCompiler();
            XQueryExecutable exp = comp.compile(this.mExpression);
            if (this.mSerializer == null) {
                Serializer out = new Serializer();
                out.setOutputProperty(Serializer.Property.METHOD, "xml");
                out.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
                out.setOutputStream(this.mOut);
                this.mSerializer = out;
            }
            XQueryEvaluator exe = exp.load();
            exe.setSource((Source)((Object)doc));
            exe.run((Destination)this.mSerializer);
            return null;
        }
        catch (SaxonApiException e) {
            LOGGER.error("Saxon Exception: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

