/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.saxon.evaluator;

import java.util.concurrent.Callable;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SAXDestination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XQueryExecutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.treetank.api.ISession;
import org.treetank.saxon.wrapper.DocumentWrapper;
import org.xml.sax.ContentHandler;

public final class XQueryEvaluatorSAXHandler
implements Callable<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XQueryEvaluatorSAXHandler.class);
    private final String mExpression;
    private final ISession mSession;
    private final ContentHandler mHandler;

    public XQueryEvaluatorSAXHandler(String expression, ISession paramSession, ContentHandler handler) {
        this.mExpression = expression;
        this.mSession = paramSession;
        this.mHandler = handler;
    }

    @Override
    public Void call() throws Exception {
        try {
            Processor proc = new Processor(false);
            Configuration config = proc.getUnderlyingConfiguration();
            DocumentWrapper doc = new DocumentWrapper(this.mSession, config);
            XQueryCompiler comp = proc.newXQueryCompiler();
            XQueryExecutable exp = comp.compile(this.mExpression);
            XQueryEvaluator exe = exp.load();
            exe.setSource((Source)((Object)doc));
            exe.run((Destination)new SAXDestination(this.mHandler));
            return null;
        }
        catch (SaxonApiException e) {
            LOGGER.error("Saxon Exception: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

