/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.saxon.evaluator;

import java.io.File;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.treetank.api.ISession;
import org.treetank.exception.TTException;
import org.treetank.saxon.wrapper.DocumentWrapper;

public final class XSLTEvaluator
implements Callable<OutputStream> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XSLTEvaluator.class);
    private final transient File mStylesheet;
    private final transient OutputStream mOut;
    private transient Serializer mSerializer;
    private final transient ISession mSession;

    public XSLTEvaluator(ISession paramSession, File stylesheet, OutputStream out) {
        this(paramSession, stylesheet, out, null);
    }

    public XSLTEvaluator(ISession paramSession, File paramStyle, OutputStream paramOut, Serializer paramSerializer) {
        this.mSession = paramSession;
        this.mStylesheet = paramStyle;
        this.mOut = paramOut;
        this.mSerializer = paramSerializer;
    }

    @Override
    public OutputStream call() {
        Processor proc = new Processor(false);
        XsltCompiler comp = proc.newXsltCompiler();
        try {
            Configuration config = proc.getUnderlyingConfiguration();
            DocumentWrapper doc = new DocumentWrapper(this.mSession, config);
            XsltExecutable exp = comp.compile((Source)new StreamSource(this.mStylesheet));
            XdmNode source = proc.newDocumentBuilder().build((Source)((Object)doc));
            if (this.mSerializer == null) {
                Serializer out = new Serializer();
                out.setOutputProperty(Serializer.Property.METHOD, "xml");
                out.setOutputProperty(Serializer.Property.INDENT, "yes");
                out.setOutputStream(this.mOut);
                this.mSerializer = out;
            } else {
                this.mSerializer.setOutputStream(this.mOut);
            }
            XsltTransformer trans = exp.load();
            trans.setInitialContextNode(source);
            trans.setDestination((Destination)this.mSerializer);
            trans.transform();
        }
        catch (SaxonApiException e) {
            LOGGER.error("Saxon exception: " + e.getMessage(), (Throwable)e);
        }
        catch (TTException e) {
            LOGGER.error("TT exception: " + e.getMessage(), (Throwable)e);
        }
        return this.mOut;
    }
}

