/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.saxon.wrapper;

import java.util.Collections;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.treetank.access.NodeReadTrx;
import org.treetank.api.INodeReadTrx;
import org.treetank.api.ISession;
import org.treetank.axis.DescendantAxis;
import org.treetank.data.ElementNode;
import org.treetank.exception.TTException;
import org.treetank.saxon.wrapper.NodeWrapper;

public final class DocumentWrapper
implements DocumentInfo {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DocumentWrapper.class);
    protected final transient ISession mSession;
    protected transient String mBaseURI;
    protected transient Configuration mConfig;
    protected transient long documentNumber;
    private final NodeWrapper mNodeWrapper;

    public DocumentWrapper(ISession pSession, Configuration pConfig) throws TTException {
        this.mSession = pSession;
        this.mBaseURI = pSession.toString();
        this.setConfiguration(pConfig);
        this.mNodeWrapper = new NodeWrapper(this, 0L);
    }

    public String[] getUnparsedEntity(String name) {
        throw new UnsupportedOperationException("Currently not supported by Treetank!");
    }

    public Iterator<String> getUnparsedEntityNames() {
        return Collections.EMPTY_LIST.iterator();
    }

    public NodeInfo selectID(String ID, boolean getParent) {
        try {
            NodeReadTrx rtx = new NodeReadTrx(this.mSession.beginBucketRtx(this.mSession.getMostRecentVersion()));
            DescendantAxis axis = new DescendantAxis((INodeReadTrx)rtx, true);
            while (axis.hasNext()) {
                int attCount;
                if (rtx.getNode().getKind() == 1 && (attCount = ((ElementNode)rtx.getNode()).getAttributeCount()) > 0) {
                    long nodeKey = rtx.getNode().getDataKey();
                    for (int index = 0; index < attCount; ++index) {
                        rtx.moveToAttribute(index);
                        if ("xml:id".equalsIgnoreCase(rtx.getQNameOfCurrentNode().getLocalPart()) && ID.equals(rtx.getValueOfCurrentNode())) {
                            if (getParent) {
                                rtx.moveTo(rtx.getNode().getParentKey());
                            }
                            return new NodeWrapper(this, rtx.getNode().getDataKey());
                        }
                        rtx.moveTo(nodeKey);
                    }
                }
                axis.next();
            }
            rtx.close();
        }
        catch (TTException exc) {
            LOGGER.error(exc.toString());
        }
        return null;
    }

    public NamePool getNamePool() {
        return this.mConfig.getNamePool();
    }

    public void setConfiguration(Configuration config) {
        this.mConfig = config;
        this.documentNumber = config.getDocumentNumberAllocator().allocateDocumentNumber();
    }

    public Configuration getConfiguration() {
        return this.mConfig;
    }

    public String getBaseURI() {
        return this.mBaseURI;
    }

    protected void setBaseURI(String baseURI) {
        this.mBaseURI = baseURI;
    }

    public Object getUserData(String arg0) {
        return null;
    }

    public void setUserData(String arg0, Object arg1) {
    }

    public Value atomize() throws XPathException {
        return this.getNodeWrapper().atomize();
    }

    public int compareOrder(NodeInfo arg0) {
        return this.getNodeWrapper().compareOrder(arg0);
    }

    public void copy(Receiver arg0, int arg1, int arg2) throws XPathException {
        this.getNodeWrapper().copy(arg0, arg1, arg2);
    }

    public void generateId(FastStringBuffer arg0) {
        this.getNodeWrapper().generateId(arg0);
    }

    public String getAttributeValue(int arg0) {
        return this.getNodeWrapper().getAttributeValue(arg0);
    }

    public int getColumnNumber() {
        return this.getNodeWrapper().getColumnNumber();
    }

    public String getDisplayName() {
        return this.getNodeWrapper().getDisplayName();
    }

    public long getDocumentNumber() {
        return this.getNodeWrapper().getDocumentNumber();
    }

    public DocumentInfo getDocumentRoot() {
        return this.getNodeWrapper().getDocumentRoot();
    }

    public int getFingerprint() {
        return this.getNodeWrapper().getFingerprint();
    }

    public int getLineNumber() {
        return this.getNodeWrapper().getLineNumber();
    }

    public String getLocalPart() {
        return this.getNodeWrapper().getLocalPart();
    }

    public int getNameCode() {
        return this.getNodeWrapper().getNameCode();
    }

    public int getNodeKind() {
        return this.getNodeWrapper().getNodeKind();
    }

    public NodeInfo getParent() {
        return this.getNodeWrapper().getParent();
    }

    public String getPrefix() {
        return this.getNodeWrapper().getPrefix();
    }

    public NodeInfo getRoot() {
        return this.getNodeWrapper().getRoot();
    }

    public String getStringValue() {
        return this.getNodeWrapper().getStringValue();
    }

    public String getSystemId() {
        return this.getNodeWrapper().getSystemId();
    }

    public int getTypeAnnotation() {
        return this.getNodeWrapper().getTypeAnnotation();
    }

    public String getURI() {
        return this.getNodeWrapper().getURI();
    }

    public boolean hasChildNodes() {
        return this.getNodeWrapper().hasChildNodes();
    }

    public boolean isId() {
        return this.getNodeWrapper().isId();
    }

    public boolean isIdref() {
        return this.getNodeWrapper().isIdref();
    }

    public boolean isNilled() {
        return this.getNodeWrapper().isNilled();
    }

    public boolean isSameNodeInfo(NodeInfo arg0) {
        return this.getNodeWrapper().isSameNodeInfo(arg0);
    }

    public AxisIterator iterateAxis(byte arg0) {
        return this.getNodeWrapper().iterateAxis(arg0);
    }

    public AxisIterator iterateAxis(byte arg0, NodeTest arg1) {
        return this.getNodeWrapper().iterateAxis(arg0, arg1);
    }

    public void setSystemId(String arg0) {
        this.getNodeWrapper().setSystemId(arg0);
    }

    public CharSequence getStringValueCS() {
        return this.getNodeWrapper().getStringValueCS();
    }

    public SequenceIterator getTypedValue() throws XPathException {
        return this.getNodeWrapper().getTypedValue();
    }

    public NodeWrapper getNodeWrapper() {
        return this.mNodeWrapper;
    }

    public String getAttributeValue(String arg0, String arg1) {
        return this.getNodeWrapper().getAttributeValue(arg0, arg1);
    }

    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] arg0) {
        return this.getNodeWrapper().getDeclaredNamespaces(arg0);
    }

    public SchemaType getSchemaType() {
        return this.getNodeWrapper().getSchemaType();
    }

    public boolean isTyped() {
        return false;
    }
}

