/*
 * Decompiled with CFR 0.152.
 */
package org.treetank.saxon.wrapper;

import javax.xml.namespace.QName;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyAxisIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.SiblingCountingNode;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.treetank.access.NodeReadTrx;
import org.treetank.api.INodeReadTrx;
import org.treetank.axis.AbsAxis;
import org.treetank.axis.AncestorAxis;
import org.treetank.axis.AttributeAxis;
import org.treetank.axis.ChildAxis;
import org.treetank.axis.DescendantAxis;
import org.treetank.axis.FilterAxis;
import org.treetank.axis.FollowingAxis;
import org.treetank.axis.FollowingSiblingAxis;
import org.treetank.axis.ParentAxis;
import org.treetank.axis.PrecedingAxis;
import org.treetank.axis.PrecedingSiblingAxis;
import org.treetank.axis.filter.AbsFilter;
import org.treetank.axis.filter.TextFilter;
import org.treetank.data.ElementNode;
import org.treetank.data.interfaces.ITreeData;
import org.treetank.data.interfaces.ITreeStructData;
import org.treetank.exception.TTException;
import org.treetank.saxon.wrapper.DocumentWrapper;

public class NodeWrapper
implements NodeInfo,
VirtualNode,
SiblingCountingNode {
    protected final transient int nodeKind;
    protected transient DocumentWrapper mDocWrapper;
    protected static final Logger LOGGER = LoggerFactory.getLogger(NodeWrapper.class);
    protected final transient long mKey;
    protected final transient ITreeData treeData;
    protected final transient QName qName;

    protected NodeWrapper(DocumentWrapper pDocWrapper, long pNodekeyToStart) throws TTException {
        this.mDocWrapper = pDocWrapper;
        NodeReadTrx rtx = new NodeReadTrx(this.mDocWrapper.mSession.beginBucketRtx(this.mDocWrapper.mSession.getMostRecentVersion()));
        rtx.moveTo(pNodekeyToStart);
        this.nodeKind = rtx.getNode().getKind();
        this.mKey = rtx.getNode().getDataKey();
        this.treeData = rtx.getNode();
        this.qName = this.nodeKind == 1 || this.nodeKind == 2 ? rtx.getQNameOfCurrentNode() : null;
        rtx.close();
    }

    public Value atomize() throws XPathException {
        StringValue value = null;
        switch (this.nodeKind) {
            case 7: 
            case 8: {
                value = new StringValue(this.getStringValueCS());
                break;
            }
            default: {
                value = new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        return value;
    }

    public int compareOrder(NodeInfo node) {
        int retVal = this.getDocumentNumber() != node.getDocumentNumber() ? -2 : (((NodeWrapper)node).mKey > this.mKey ? -1 : (((NodeWrapper)node).mKey == this.mKey ? 0 : 1));
        return retVal;
    }

    public void copy(Receiver out, int copyOption, int locationId) throws XPathException {
        Navigator.copy((NodeInfo)this, (Receiver)out, (int)copyOption, (int)locationId);
    }

    public void generateId(FastStringBuffer buf) {
        buf.append(String.valueOf(this.mKey));
    }

    public String getAttributeValue(int fingerprint) {
        String attVal = null;
        NameTest test = new NameTest(2, fingerprint, this.getNamePool());
        AxisIterator iterator = this.iterateAxis((byte)2, (NodeTest)test);
        NodeInfo attribute = iterator.next();
        if (attribute != null) {
            attVal = attribute.getStringValue();
        }
        return attVal;
    }

    public String getBaseURI() {
        String baseURI = null;
        for (NodeWrapper node = this; node != null && (baseURI = node.getAttributeValue(385)) == null; node = node.getParent()) {
        }
        if (baseURI == null) {
            baseURI = this.mDocWrapper.getBaseURI();
        }
        return baseURI;
    }

    public int getColumnNumber() {
        throw new UnsupportedOperationException("Not supported by TreeTank.");
    }

    public Configuration getConfiguration() {
        return this.mDocWrapper.getConfiguration();
    }

    public String getDisplayName() {
        String dName = "";
        switch (this.nodeKind) {
            case 1: 
            case 2: {
                String prefix = this.getPrefix();
                if (prefix.isEmpty()) {
                    dName = this.getLocalPart();
                    break;
                }
                dName = prefix + ":" + this.getLocalPart();
                break;
            }
            case 7: 
            case 13: {
                dName = this.getLocalPart();
                break;
            }
        }
        return dName;
    }

    public long getDocumentNumber() {
        return this.mDocWrapper.getBaseURI().hashCode();
    }

    public DocumentInfo getDocumentRoot() {
        return this.mDocWrapper;
    }

    public int getFingerprint() {
        int nameCount = this.getNameCode();
        int retVal = nameCount == -1 ? -1 : nameCount & 0xFFFFF;
        return retVal;
    }

    public int getLineNumber() {
        throw new UnsupportedOperationException("Not supported by TreeTank.");
    }

    public String getLocalPart() {
        String localPart = "";
        switch (this.nodeKind) {
            case 1: 
            case 2: {
                localPart = this.qName.getLocalPart();
                break;
            }
        }
        return localPart;
    }

    public int getNameCode() {
        int nameCode = -1;
        switch (this.nodeKind) {
            case 1: 
            case 2: 
            case 7: {
                nameCode = this.mDocWrapper.getNamePool().allocate(this.getPrefix(), this.getURI(), this.getLocalPart());
                break;
            }
        }
        return nameCode;
    }

    public NamePool getNamePool() {
        return this.mDocWrapper.getNamePool();
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    public NodeInfo getParent() {
        try {
            NodeWrapper parent = null;
            INodeReadTrx rtx = this.createRtxAndMove();
            if (rtx.getNode().hasParent()) {
                parent = new NodeWrapper(this.mDocWrapper, rtx.getNode().getParentKey());
            }
            rtx.close();
            return parent;
        }
        catch (TTException exc) {
            LOGGER.error(exc.toString());
            return null;
        }
    }

    public String getPrefix() {
        String prefix = "";
        switch (this.nodeKind) {
            case 1: 
            case 2: {
                prefix = this.qName.getPrefix();
                break;
            }
        }
        return prefix;
    }

    public NodeInfo getRoot() {
        return this.mDocWrapper;
    }

    public final String getStringValue() {
        return this.getStringValueCS().toString();
    }

    public final CharSequence getStringValueCS() {
        String mValue = "";
        try {
            INodeReadTrx rtx = this.createRtxAndMove();
            switch (this.nodeKind) {
                case 1: 
                case 9: {
                    mValue = this.expandString();
                    break;
                }
                case 2: {
                    mValue = NodeWrapper.emptyIfNull(rtx.getValueOfCurrentNode());
                    break;
                }
                case 3: {
                    mValue = rtx.getValueOfCurrentNode();
                    break;
                }
                case 7: 
                case 8: {
                    mValue = NodeWrapper.emptyIfNull(rtx.getValueOfCurrentNode());
                    break;
                }
                default: {
                    mValue = "";
                    break;
                }
            }
        }
        catch (TTException exc) {
            LOGGER.error(exc.toString());
        }
        return mValue;
    }

    private String expandString() {
        FastStringBuffer fsb = new FastStringBuffer(64);
        try {
            INodeReadTrx rtx = this.createRtxAndMove();
            FilterAxis axis = new FilterAxis((AbsAxis)new DescendantAxis(rtx), rtx, new AbsFilter[]{new TextFilter(rtx)});
            while (axis.hasNext()) {
                if (rtx.getNode().getKind() == 3) {
                    fsb.append(rtx.getValueOfCurrentNode());
                }
                axis.next();
            }
            rtx.close();
        }
        catch (TTException exc) {
            LOGGER.error(exc.toString());
        }
        return fsb.condense().toString();
    }

    public String getSystemId() {
        return this.mDocWrapper.getBaseURI();
    }

    public int getTypeAnnotation() {
        int type = 0;
        type = this.nodeKind == 2 ? 631 : 630;
        return type;
    }

    public String getURI() {
        String URI2 = "";
        switch (this.nodeKind) {
            case 1: 
            case 2: 
            case 13: {
                if ("".equals(this.qName.getPrefix())) break;
                URI2 = this.qName.getNamespaceURI();
                break;
            }
        }
        return URI2;
    }

    public boolean hasChildNodes() {
        boolean hasChildNodes = false;
        try {
            INodeReadTrx rtx = this.createRtxAndMove();
            if (((ITreeStructData)rtx.getNode()).getChildCount() > 0L) {
                hasChildNodes = true;
            }
            rtx.close();
        }
        catch (TTException exc) {
            LOGGER.error(exc.toString());
        }
        return hasChildNodes;
    }

    public boolean isId() {
        return false;
    }

    public boolean isIdref() {
        throw new UnsupportedOperationException("Currently not supported by Treetank!");
    }

    public boolean isNilled() {
        throw new UnsupportedOperationException("Currently not supported by Treetank!");
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        boolean retVal = !(other instanceof NodeInfo) ? false : ((NodeWrapper)other).mKey == this.mKey;
        return retVal;
    }

    public AxisIterator iterateAxis(byte axisNumber) {
        return this.iterateAxis(axisNumber, (NodeTest)AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        Object returnVal = null;
        try {
            INodeReadTrx rtx = this.createRtxAndMove();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("NODE TEST: " + nodeTest);
            }
            switch (axisNumber) {
                case 0: {
                    if (this.getNodeKind() == 9) {
                        returnVal = EmptyAxisIterator.emptyAxisIterator();
                        break;
                    }
                    returnVal = new Navigator.AxisFilter((AxisIterator)new SaxonEnumeration((AbsAxis)new AncestorAxis(rtx)), nodeTest);
                    break;
                }
                case 1: {
                    if (this.getNodeKind() == 9) {
                        returnVal = Navigator.filteredSingleton((NodeInfo)this, (NodeTest)nodeTest);
                        break;
                    }
                    returnVal = new Navigator.AxisFilter((AxisIterator)new SaxonEnumeration((AbsAxis)new AncestorAxis(rtx, true)), nodeTest);
                    break;
                }
                case 2: {
                    if (this.getNodeKind() != 1) {
                        returnVal = EmptyAxisIterator.emptyAxisIterator();
                        break;
                    }
                    returnVal = new Navigator.AxisFilter((AxisIterator)new SaxonEnumeration((AbsAxis)new AttributeAxis(rtx)), nodeTest);
                    break;
                }
                case 3: {
                    if (this.hasChildNodes()) {
                        returnVal = new Navigator.AxisFilter((AxisIterator)new SaxonEnumeration((AbsAxis)new ChildAxis(rtx)), nodeTest);
                        break;
                    }
                    returnVal = EmptyAxisIterator.emptyAxisIterator();
                    break;
                }
                case 4: {
                    if (this.hasChildNodes()) {
                        returnVal = new Navigator.AxisFilter((AxisIterator)new SaxonEnumeration((AbsAxis)new DescendantAxis(rtx)), nodeTest);
                        break;
                    }
                    returnVal = EmptyAxisIterator.emptyAxisIterator();
                    break;
                }
                case 5: {
                    returnVal = new Navigator.AxisFilter((AxisIterator)new SaxonEnumeration((AbsAxis)new DescendantAxis(rtx, true)), nodeTest);
                    break;
                }
                case 6: {
                    returnVal = new Navigator.AxisFilter((AxisIterator)new SaxonEnumeration((AbsAxis)new FollowingAxis(rtx)), nodeTest);
                    break;
                }
                case 7: {
                    switch (this.nodeKind) {
                        case 2: 
                        case 9: 
                        case 13: {
                            returnVal = EmptyAxisIterator.emptyAxisIterator();
                            break;
                        }
                        default: {
                            returnVal = new Navigator.AxisFilter((AxisIterator)new SaxonEnumeration((AbsAxis)new FollowingSiblingAxis(rtx)), nodeTest);
                        }
                    }
                }
                case 8: {
                    returnVal = EmptyAxisIterator.emptyAxisIterator();
                    break;
                }
                case 9: {
                    returnVal = rtx.getNode().getParentKey() == 9L ? EmptyAxisIterator.emptyAxisIterator() : new Navigator.AxisFilter((AxisIterator)new SaxonEnumeration((AbsAxis)new ParentAxis(rtx)), nodeTest);
                }
                case 10: {
                    returnVal = new Navigator.AxisFilter((AxisIterator)new SaxonEnumeration((AbsAxis)new PrecedingAxis(rtx)), nodeTest);
                    break;
                }
                case 11: {
                    switch (this.nodeKind) {
                        case 2: 
                        case 9: 
                        case 13: {
                            returnVal = EmptyAxisIterator.emptyAxisIterator();
                            break;
                        }
                        default: {
                            returnVal = new Navigator.AxisFilter((AxisIterator)new SaxonEnumeration((AbsAxis)new PrecedingSiblingAxis(rtx)), nodeTest);
                        }
                    }
                }
                case 12: {
                    returnVal = Navigator.filteredSingleton((NodeInfo)this, (NodeTest)nodeTest);
                    break;
                }
                case 13: {
                    returnVal = new Navigator.AxisFilter((AxisIterator)new Navigator.PrecedingEnumeration((NodeInfo)this, true), nodeTest);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown axis number " + axisNumber);
                }
            }
        }
        catch (TTException exc) {
            LOGGER.error(exc.toString());
        }
        return returnVal;
    }

    public void setSystemId(String systemId) {
        this.mDocWrapper.setBaseURI(systemId);
    }

    public SequenceIterator getTypedValue() throws XPathException {
        return SingletonIterator.makeIterator((Item)((AtomicValue)this.atomize()));
    }

    public Object getRealNode() {
        return this.getUnderlyingNode();
    }

    public Object getUnderlyingNode() {
        return this.treeData;
    }

    public int getSiblingPosition() {
        int index = 0;
        try {
            INodeReadTrx rtx = this.createRtxAndMove();
            while (((ITreeStructData)rtx.getNode()).hasLeftSibling()) {
                rtx.moveTo(((ITreeStructData)rtx.getNode()).getLeftSiblingKey());
                ++index;
            }
            rtx.close();
        }
        catch (TTException exc) {
            LOGGER.error(exc.toString());
        }
        return index;
    }

    private final INodeReadTrx createRtxAndMove() throws TTException {
        NodeReadTrx rtx = new NodeReadTrx(this.mDocWrapper.mSession.beginBucketRtx(this.mDocWrapper.mSession.getMostRecentVersion()));
        rtx.moveTo(this.mKey);
        return rtx;
    }

    private static String emptyIfNull(String s) {
        return s == null ? "" : s;
    }

    public String getAttributeValue(String arg0, String arg1) {
        if (this.nodeKind == 1) {
            int count = ((ElementNode)this.treeData).getAttributeCount();
            if (count == 0) {
                return null;
            }
            try {
                INodeReadTrx rtx = this.createRtxAndMove();
                for (int i = 0; i < count; ++i) {
                    rtx.moveTo(((ElementNode)this.treeData).getAttributeKey(i));
                    QName name = rtx.getQNameOfCurrentNode();
                    if (!name.getNamespaceURI().equals(arg0) || !name.getLocalPart().equals(arg1)) continue;
                    rtx.close();
                    return rtx.getValueOfCurrentNode();
                }
                rtx.close();
            }
            catch (TTException exc) {
                LOGGER.error(exc.toString());
            }
            return null;
        }
        return null;
    }

    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] arg0) {
        if (this.nodeKind == 1) {
            int count = ((ElementNode)this.treeData).getNamespaceCount();
            if (count == 0) {
                return new NamespaceBinding[0];
            }
            NamespaceBinding[] returnVal = new NamespaceBinding[count];
            try {
                INodeReadTrx rtx = this.createRtxAndMove();
                for (int i = 0; i < count; ++i) {
                    rtx.moveTo(((ElementNode)this.treeData).getNamespaceKey(i));
                    String prefix = this.getPrefix();
                    String uri = this.getURI();
                    rtx.moveTo(this.mKey);
                    returnVal[i] = new NamespaceBinding(prefix, uri);
                }
                rtx.close();
            }
            catch (TTException exc) {
                LOGGER.error(exc.toString());
            }
            if (arg0 != null && returnVal.length < arg0.length) {
                System.arraycopy(returnVal, 0, arg0, 0, returnVal.length);
            }
            return returnVal;
        }
        return null;
    }

    public SchemaType getSchemaType() {
        return AnySimpleType.getInstance();
    }

    public final class SaxonEnumeration
    extends Navigator.BaseEnumeration {
        private final AbsAxis mAxis;

        public SaxonEnumeration(AbsAxis paramAxis) {
            this.mAxis = paramAxis;
        }

        public void advance() {
            if (this.mAxis.hasNext()) {
                long nextKey = this.mAxis.next();
                try {
                    this.current = new NodeWrapper(NodeWrapper.this.mDocWrapper, nextKey);
                }
                catch (TTException exc) {
                    this.current = null;
                }
            } else {
                try {
                    this.mAxis.close();
                }
                catch (TTException exc) {
                    LOGGER.error(exc.toString());
                }
                this.current = null;
            }
        }

        public AxisIterator<NodeInfo> getAnother() {
            return new SaxonEnumeration(this.mAxis);
        }
    }
}

