/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.Mustache;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.DefaultConfiguration;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.engine.parser.DefaultParser;
import org.trimou.engine.parser.DefaultParsingHandler;
import org.trimou.engine.parser.Parser;
import org.trimou.engine.segment.Segments;
import org.trimou.engine.segment.TemplateSegment;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.util.Checker;
import org.trimou.util.Strings;

class DefaultMustacheEngine
implements MustacheEngine {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMustacheEngine.class);
    private LoadingCache<String, Optional<TemplateSegment>> templateCache;
    private Configuration configuration;
    private Parser parser;

    DefaultMustacheEngine() {
    }

    DefaultMustacheEngine(MustacheEngineBuilder builder) {
        this.configuration = new DefaultConfiguration(builder);
        this.templateCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Optional<TemplateSegment>>(){

            public Optional<TemplateSegment> load(String key) throws Exception {
                TemplateLocator locator;
                if (DefaultMustacheEngine.this.configuration.getTemplateLocators() == null || DefaultMustacheEngine.this.configuration.getTemplateLocators().isEmpty()) {
                    return Optional.absent();
                }
                Reader reader = null;
                Iterator<TemplateLocator> i$ = DefaultMustacheEngine.this.configuration.getTemplateLocators().iterator();
                while (i$.hasNext() && (reader = (locator = i$.next()).locate(key)) == null) {
                }
                if (reader == null) {
                    return Optional.absent();
                }
                return Optional.of((Object)DefaultMustacheEngine.this.parse(key, reader));
            }
        });
        this.parser = new DefaultParser(this);
        if (this.configuration.getBooleanPropertyValue(EngineConfigurationKey.PRECOMPILE_ALL_TEMPLATES).booleanValue()) {
            HashSet<String> templateNames = new HashSet<String>();
            for (TemplateLocator locator : this.configuration.getTemplateLocators()) {
                templateNames.addAll(locator.getAllAvailableNames());
            }
            for (String templateName : templateNames) {
                this.getTemplateFromCache(templateName);
            }
        }
    }

    @Override
    public Mustache getMustache(String templateName) {
        Checker.checkArgumentNullOrEmpty(templateName);
        return this.getTemplateFromCache(templateName);
    }

    @Override
    public Mustache compileMustache(String templateName, String templateContent) {
        Checker.checkArgumentNullOrEmpty(templateName);
        Checker.checkArgumentNullOrEmpty(templateContent);
        return this.parse(templateName, new StringReader(templateContent));
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void invalidateTemplateCache() {
        this.templateCache.invalidateAll();
    }

    public LoadingCache<String, Optional<TemplateSegment>> getTemplateCache() {
        return this.templateCache;
    }

    private TemplateSegment parse(String templateName, Reader reader) {
        DefaultParsingHandler handler = new DefaultParsingHandler();
        this.parser.parse(templateName, reader, handler);
        TemplateSegment template = handler.getCompiledTemplate();
        if (logger.isTraceEnabled()) {
            logger.trace(Segments.getSegmentTree(template));
        }
        return template;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.getClass().getName());
        builder.append("]");
        builder.append(Strings.LINE_SEPARATOR);
        builder.append(this.configuration.toString());
        return builder.toString();
    }

    private TemplateSegment getTemplateFromCache(String templateName) {
        try {
            return (TemplateSegment)((Optional)this.templateCache.get((Object)templateName)).orNull();
        }
        catch (ExecutionException e) {
            throw new MustacheException(MustacheProblem.TEMPLATE_LOADING_ERROR, (Throwable)e);
        }
    }
}

