/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.DefaultMustacheEngine;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.locale.LocaleSupport;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.engine.resolver.Resolver;
import org.trimou.engine.text.TextSupport;
import org.trimou.util.Checker;

public class MustacheEngineBuilder {
    private static final Logger logger = LoggerFactory.getLogger(MustacheEngineBuilder.class);
    private boolean omitServiceLoaderResolvers = false;
    private Set<Resolver> resolvers = null;
    private Set<TemplateLocator> templateLocators = null;
    private Map<String, Object> globalData = null;
    private TextSupport textSupport = null;
    private LocaleSupport localeSupport = null;
    private Map<String, Object> properties = new HashMap<String, Object>(EngineConfigurationKey.values().length);
    private List<EngineBuiltCallback> engineReadyCallbacks = null;

    private MustacheEngineBuilder() {
    }

    public MustacheEngine build() {
        DefaultMustacheEngine engine = new DefaultMustacheEngine(this);
        if (this.engineReadyCallbacks != null) {
            for (EngineBuiltCallback callback : this.engineReadyCallbacks) {
                callback.engineBuilt(engine);
            }
        }
        logger.info("Engine built... \n{}", (Object)((Object)engine).toString());
        this.performCleanup();
        return engine;
    }

    public MustacheEngineBuilder addGlobalData(String name, Object value) {
        if (this.globalData == null) {
            this.globalData = new HashMap<String, Object>();
        }
        this.globalData.put(name, value);
        return this;
    }

    public MustacheEngineBuilder addTemplateLocator(TemplateLocator locator) {
        if (this.templateLocators == null) {
            this.templateLocators = new HashSet<TemplateLocator>();
        }
        this.templateLocators.add(locator);
        return this;
    }

    public MustacheEngineBuilder addResolver(Resolver resolver) {
        if (this.resolvers == null) {
            this.resolvers = new HashSet<Resolver>();
        }
        this.resolvers.add(resolver);
        return this;
    }

    public MustacheEngineBuilder setProperty(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public MustacheEngineBuilder setProperty(ConfigurationKey configurationKey, Object value) {
        this.setProperty(configurationKey.get(), value);
        return this;
    }

    public MustacheEngineBuilder setTextSupport(TextSupport textSupport) {
        this.textSupport = textSupport;
        return this;
    }

    public MustacheEngineBuilder setLocaleSupport(LocaleSupport localeSupport) {
        this.localeSupport = localeSupport;
        return this;
    }

    public MustacheEngineBuilder registerCallback(EngineBuiltCallback callback) {
        Checker.checkArgumentNull(callback);
        if (this.engineReadyCallbacks == null) {
            this.engineReadyCallbacks = new ArrayList<EngineBuiltCallback>();
        }
        this.engineReadyCallbacks.add(callback);
        return this;
    }

    public MustacheEngineBuilder omitServiceLoaderResolvers() {
        this.omitServiceLoaderResolvers = true;
        return this;
    }

    public static MustacheEngineBuilder newBuilder() {
        return new MustacheEngineBuilder();
    }

    public Set<TemplateLocator> getTemplateLocators() {
        return this.templateLocators;
    }

    public Set<Resolver> getResolvers() {
        return this.resolvers;
    }

    public Map<String, Object> getGlobalData() {
        return this.globalData;
    }

    public TextSupport getTextSupport() {
        return this.textSupport;
    }

    public LocaleSupport getLocaleSupport() {
        return this.localeSupport;
    }

    public boolean isOmitServiceLoaderResolvers() {
        return this.omitServiceLoaderResolvers;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    private void performCleanup() {
        this.omitServiceLoaderResolvers = false;
        this.resolvers = null;
        this.templateLocators = null;
        this.globalData = null;
        this.textSupport = null;
        this.localeSupport = null;
        this.properties.clear();
        this.engineReadyCallbacks = null;
    }

    public static interface EngineBuiltCallback {
        public void engineBuilt(MustacheEngine var1);
    }
}

