/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine;

import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.parser.Delimiters;

public enum MustacheTagType {
    VARIABLE(null),
    UNESCAPE_VARIABLE(Character.valueOf('&')),
    SECTION(Character.valueOf('#')),
    INVERTED_SECTION(Character.valueOf('^')),
    SECTION_END(Character.valueOf('/')),
    COMMENT(Character.valueOf('!')),
    PARTIAL(Character.valueOf('>')),
    DELIMITER(Character.valueOf('=')),
    EXTEND(Character.valueOf('<')),
    EXTEND_SECTION(Character.valueOf('$'));

    private Character command;

    private MustacheTagType(Character command) {
        this.command = command;
    }

    public Character getCommand() {
        return this.command;
    }

    public static MustacheTagType fromBuffer(String buffer, Delimiters delimiters) {
        if (delimiters.hasDefaultDelimitersSet() && buffer.charAt(0) == ((String)EngineConfigurationKey.START_DELIMITER.getDefaultValue()).charAt(0) && buffer.charAt(buffer.length() - 1) == ((String)EngineConfigurationKey.END_DELIMITER.getDefaultValue()).charAt(0)) {
            return UNESCAPE_VARIABLE;
        }
        Character command = Character.valueOf(buffer.charAt(0));
        for (MustacheTagType type : MustacheTagType.values()) {
            if (!command.equals(type.getCommand())) continue;
            return type;
        }
        return VARIABLE;
    }

    public String extractContent(String buffer) {
        switch (this) {
            case VARIABLE: {
                return buffer.trim();
            }
            case UNESCAPE_VARIABLE: {
                return buffer.charAt(0) == ((String)EngineConfigurationKey.START_DELIMITER.getDefaultValue()).charAt(0) ? buffer.substring(1, buffer.length() - 1).trim() : buffer.substring(1).trim();
            }
            case SECTION: 
            case INVERTED_SECTION: 
            case PARTIAL: 
            case EXTEND: 
            case EXTEND_SECTION: 
            case SECTION_END: 
            case COMMENT: {
                return buffer.substring(1).trim();
            }
            case DELIMITER: {
                return buffer.trim();
            }
        }
        return null;
    }
}

