/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.locale.DefaultLocaleSupport;
import org.trimou.engine.locale.LocaleSupport;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.engine.priority.HighPriorityComparator;
import org.trimou.engine.resolver.Resolver;
import org.trimou.engine.text.DefaultTextSupport;
import org.trimou.engine.text.TextSupport;
import org.trimou.util.Strings;

public class DefaultConfiguration
implements Configuration {
    private static final String RESOURCE_FILE = "/trimou.properties";
    private List<TemplateLocator> templateLocators = null;
    private List<Resolver> resolvers = null;
    private Map<String, Object> globalData = null;
    private TextSupport textSupport;
    private LocaleSupport localeSupport;
    private Map<String, Object> properties;

    public DefaultConfiguration(MustacheEngineBuilder builder) {
        this.loadResolvers(builder);
        this.initializeTextSupport(builder);
        this.initializeLocaleSupport(builder);
        this.initializeTemplateLocators(builder);
        this.initializeGlobalData(builder);
        this.initializeProperties(builder);
        this.initializeResolvers();
    }

    @Override
    public List<Resolver> getResolvers() {
        return this.resolvers;
    }

    @Override
    public Map<String, Object> getGlobalData() {
        return this.globalData;
    }

    @Override
    public List<TemplateLocator> getTemplateLocators() {
        return this.templateLocators;
    }

    @Override
    public TextSupport getTextSupport() {
        return this.textSupport;
    }

    @Override
    public LocaleSupport getLocaleSupport() {
        return this.localeSupport;
    }

    @Override
    public Long getLongPropertyValue(ConfigurationKey configurationKey) {
        Long value = (Long)this.properties.get(configurationKey.get());
        if (value == null) {
            value = (Long)configurationKey.getDefaultValue();
        }
        return value;
    }

    @Override
    public String getStringPropertyValue(ConfigurationKey configurationKey) {
        Object value = this.properties.get(configurationKey.get());
        if (value == null) {
            value = configurationKey.getDefaultValue();
        }
        return value.toString();
    }

    @Override
    public Boolean getBooleanPropertyValue(ConfigurationKey configurationKey) {
        Boolean value = (Boolean)this.properties.get(configurationKey.get());
        if (value == null) {
            value = (Boolean)configurationKey.getDefaultValue();
        }
        return value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("----------");
        builder.append(Strings.LINE_SEPARATOR);
        builder.append("[");
        builder.append(this.getClass().getName());
        builder.append("]");
        if (this.templateLocators != null) {
            builder.append(Strings.LINE_SEPARATOR);
            builder.append("----------");
            builder.append(Strings.LINE_SEPARATOR);
            builder.append("[Template locators]");
            for (TemplateLocator templateLocator : this.templateLocators) {
                builder.append(Strings.LINE_SEPARATOR);
                builder.append(templateLocator.toString());
            }
        }
        if (this.resolvers != null) {
            builder.append(Strings.LINE_SEPARATOR);
            builder.append("----------");
            builder.append(Strings.LINE_SEPARATOR);
            builder.append("[Resolvers]");
            for (Resolver resolver : this.resolvers) {
                builder.append(Strings.LINE_SEPARATOR);
                builder.append(resolver.toString());
            }
        }
        builder.append(Strings.LINE_SEPARATOR);
        builder.append("----------");
        builder.append(Strings.LINE_SEPARATOR);
        builder.append("[Properties]");
        for (Map.Entry entry : this.properties.entrySet()) {
            builder.append(Strings.LINE_SEPARATOR);
            builder.append((String)entry.getKey());
            builder.append("=");
            builder.append(entry.getValue());
        }
        return builder.toString();
    }

    private Object getPropertyValue(Object defaultValue, Object suppliedValue) {
        if (defaultValue instanceof String) {
            return suppliedValue.toString();
        }
        if (defaultValue instanceof Boolean) {
            return Boolean.valueOf(suppliedValue.toString());
        }
        if (defaultValue instanceof Long) {
            return Long.valueOf(suppliedValue.toString());
        }
        throw new IllegalStateException("Unknown configuration value");
    }

    private void initializeResolvers() {
        Iterator<Resolver> iterator = this.resolvers.iterator();
        while (iterator.hasNext()) {
            iterator.next().init(this);
        }
    }

    private void loadResolvers(MustacheEngineBuilder builder) {
        this.resolvers = new ArrayList<Resolver>();
        if (builder.getResolvers() != null) {
            this.resolvers.addAll(builder.getResolvers());
        }
        if (!builder.isOmitServiceLoaderResolvers()) {
            Iterator<Resolver> iterator = ServiceLoader.load(Resolver.class).iterator();
            while (iterator.hasNext()) {
                this.resolvers.add(iterator.next());
            }
        }
        Collections.sort(this.resolvers, new HighPriorityComparator());
        this.resolvers = ImmutableList.copyOf(this.resolvers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeProperties(MustacheEngineBuilder builder) {
        Properties resourceProperties;
        ArrayList<ConfigurationKey> keysToProcess;
        block9: {
            keysToProcess = new ArrayList<ConfigurationKey>();
            for (EngineConfigurationKey engineConfigurationKey : EngineConfigurationKey.values()) {
                keysToProcess.add(engineConfigurationKey);
            }
            for (Resolver resolver : this.resolvers) {
                keysToProcess.addAll(resolver.getConfigurationKeys());
            }
            this.properties = new HashMap<String, Object>(keysToProcess.size());
            resourceProperties = new Properties();
            try {
                InputStream in = this.getClass().getResourceAsStream(RESOURCE_FILE);
                if (in == null) break block9;
                try {
                    resourceProperties.load(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        for (ConfigurationKey configKey : keysToProcess) {
            String string = configKey.get();
            Object value = builder.getProperties().get(string);
            if (value == null && (value = System.getProperty(string)) == null) {
                value = resourceProperties.getProperty(string);
            }
            this.properties.put(string, value != null ? this.getPropertyValue(configKey.getDefaultValue(), value) : configKey.getDefaultValue());
        }
    }

    private void initializeTextSupport(MustacheEngineBuilder builder) {
        this.textSupport = builder.getTextSupport() != null ? builder.getTextSupport() : new DefaultTextSupport();
    }

    private void initializeLocaleSupport(MustacheEngineBuilder builder) {
        this.localeSupport = builder.getLocaleSupport() != null ? builder.getLocaleSupport() : new DefaultLocaleSupport();
    }

    private void initializeTemplateLocators(MustacheEngineBuilder builder) {
        if (builder.getTemplateLocators() != null) {
            ArrayList<TemplateLocator> locators = new ArrayList<TemplateLocator>(builder.getTemplateLocators());
            Collections.sort(locators, new HighPriorityComparator());
            this.templateLocators = ImmutableList.copyOf(locators);
        }
    }

    private void initializeGlobalData(MustacheEngineBuilder builder) {
        if (builder.getGlobalData() != null) {
            this.globalData = ImmutableMap.copyOf(builder.getGlobalData());
        }
    }
}

