/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.context;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.context.DefaultExecutionContext;
import org.trimou.engine.resolver.Resolver;
import org.trimou.engine.segment.ExtendSectionSegment;

public class DebugExecutionContext
extends DefaultExecutionContext {
    private static final Logger logger = LoggerFactory.getLogger(DebugExecutionContext.class);

    public DebugExecutionContext(List<Resolver> resolvers) {
        super(resolvers);
    }

    @Override
    public void push(Object baseObject) {
        super.push(baseObject);
        logger.debug("Push [type: {}, stack: {}]", baseObject.getClass(), (Object)this.contextObjectStack.size());
    }

    @Override
    public Object pop() {
        Object baseObject = super.pop();
        logger.debug("Pop [type: {}, stack: {}]", baseObject.getClass(), (Object)this.contextObjectStack.size());
        return baseObject;
    }

    @Override
    public void addDefiningSection(String name, ExtendSectionSegment segment) {
        super.addDefiningSection(name, segment);
        logger.debug("Extend section set [name: {}]", (Object)name);
    }

    @Override
    protected Object resolve(Object contextObject, String key) {
        Object value = null;
        for (Resolver resolver : this.resolvers) {
            value = resolver.resolve(contextObject, key);
            if (value == null) continue;
            logger.debug("Value found [key: {}, resolver: {}]", (Object)key, resolver.getClass());
            break;
        }
        return value;
    }
}

