/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.locator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.trimou.engine.locator.PathTemplateLocator;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;

public class ClassPathTemplateLocator
extends PathTemplateLocator {
    private ClassLoader classLoader;

    public ClassPathTemplateLocator(int priority, String rootPath) {
        super(priority, rootPath);
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public ClassPathTemplateLocator(int priority, String rootPath, String suffix) {
        super(priority, rootPath, suffix);
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    private ClassPathTemplateLocator(int priority, String rootPath, String suffix, ClassLoader classLoader) {
        super(priority, rootPath, suffix);
        this.classLoader = classLoader;
    }

    private ClassPathTemplateLocator(int priority, String rootPath, ClassLoader classLoader) {
        super(priority, rootPath);
        this.classLoader = classLoader;
    }

    @Override
    public Reader locate(String templateName) {
        InputStream in = this.classLoader.getResourceAsStream(this.getRootPath() + this.addSuffix(templateName));
        if (in == null) {
            return null;
        }
        return new InputStreamReader(in);
    }

    @Override
    public Set<String> getAllAvailableNames() {
        HashSet<String> names = new HashSet<String>();
        try {
            Enumeration<URL> resources = this.classLoader.getResources(this.getRootPath());
            while (resources.hasMoreElements()) {
                File file;
                URL url = resources.nextElement();
                String urlPath = url.getFile();
                if ((urlPath = URLDecoder.decode(urlPath, "UTF-8")).startsWith("file:")) {
                    urlPath = urlPath.substring(5);
                }
                if (urlPath.indexOf(33) > 0) {
                    urlPath = urlPath.substring(0, urlPath.indexOf(33));
                }
                if (!(file = new File(urlPath)).isDirectory()) continue;
                for (File found : file.listFiles()) {
                    if (!found.isFile()) continue;
                    if (this.getSuffix() != null) {
                        if (!found.getName().endsWith(this.getSuffix())) continue;
                        names.add(this.stripSuffix(found.getName()));
                        continue;
                    }
                    names.add(found.getName());
                }
            }
        }
        catch (IOException e) {
            throw new MustacheException(MustacheProblem.TEMPLATE_LOADING_ERROR, (Throwable)e);
        }
        return names;
    }
}

