/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.locator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.trimou.engine.locator.PathTemplateLocator;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.util.Strings;

public class FileSystemTemplateLocator
extends PathTemplateLocator {
    public FileSystemTemplateLocator(int priority, String rootPath) {
        super(priority, rootPath);
        this.checkRootDir();
    }

    public FileSystemTemplateLocator(int priority, String rootPath, String suffix) {
        super(priority, rootPath, suffix);
        this.checkRootDir();
    }

    @Override
    public Reader locate(String templateName) {
        try {
            File templateFile = new File(new File(this.getRootPath()), this.addSuffix(templateName));
            if (!(templateFile.exists() && templateFile.canRead() && templateFile.isFile())) {
                return null;
            }
            return new FileReader(templateFile);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @Override
    public Set<String> getAllAvailableNames() {
        File rootDir = new File(this.getRootPath());
        File[] files = null;
        files = this.getSuffix() != null ? rootDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(FileSystemTemplateLocator.this.getSuffix());
            }
        }) : rootDir.listFiles();
        if (files == null || files.length < 1) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>();
        for (File file : files) {
            if (!file.isFile()) continue;
            names.add(this.stripSuffix(file.getName()));
        }
        return names;
    }

    @Override
    protected String getPathSeparator() {
        return Strings.FILE_SEPARATOR;
    }

    private void checkRootDir() {
        File rootDir = new File(this.getRootPath());
        if (!(rootDir.exists() && rootDir.canRead() && rootDir.isDirectory())) {
            throw new MustacheException(MustacheProblem.TEMPLATE_LOCATOR_INVALID_CONFIGURATION, "Invalid root dir: " + rootDir);
        }
    }
}

