/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.locator;

import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Set;
import org.trimou.engine.locator.TemplateLocator;

public class MapTemplateLocator
implements TemplateLocator {
    private int priority;
    private Map<String, String> templates;

    public MapTemplateLocator(int priority, Map<String, String> templates) {
        this.priority = priority;
        this.templates = templates;
    }

    public MapTemplateLocator(Map<String, String> templates) {
        this.priority = 10;
        this.templates = templates;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public Reader locate(String templateName) {
        String templateContent = this.templates.get(templateName);
        if (templateContent != null) {
            return new StringReader(templateContent);
        }
        return null;
    }

    @Override
    public Set<String> getAllAvailableNames() {
        return this.templates.keySet();
    }

    public String toString() {
        return String.format("%s [priority: %s]", this.getClass().getName(), this.getPriority());
    }
}

