/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.locator;

import org.apache.commons.lang3.StringUtils;
import org.trimou.engine.locator.TemplateLocator;

public abstract class PathTemplateLocator
implements TemplateLocator {
    private String pathSeparator = this.getPathSeparator();
    private int priority;
    private String suffix;
    private String rootPath;

    public PathTemplateLocator(int priority, String rootPath) {
        this.priority = priority;
        this.suffix = null;
        this.initRootPath(rootPath);
    }

    public PathTemplateLocator(int priority, String rootPath, String suffix) {
        this.priority = priority;
        this.suffix = suffix;
        this.initRootPath(rootPath);
    }

    private void initRootPath(String rootPath) {
        this.rootPath = rootPath.endsWith(this.pathSeparator) ? rootPath : rootPath + this.pathSeparator;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public String stripSuffix(String filename) {
        return this.suffix != null ? StringUtils.stripEnd((String)filename, (String)("." + this.suffix)) : filename;
    }

    public String addSuffix(String filename) {
        return this.suffix != null ? filename + "." + this.suffix : filename;
    }

    protected String getPathSeparator() {
        return "/";
    }

    public String toString() {
        return String.format("%s [priority: %s, suffix: %s, rootPath: %s]", this.getClass().getName(), this.getPriority(), this.getSuffix(), this.getRootPath());
    }
}

