/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheTagType;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.parser.Delimiters;
import org.trimou.engine.parser.ParsedTag;
import org.trimou.engine.parser.Parser;
import org.trimou.engine.parser.ParsingHandler;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;

public class DefaultParser
implements Parser {
    private static final int TEXT = 0;
    private static final int START_TAG = 1;
    private static final int TAG = 2;
    private static final int END_TAG = 3;
    private static final int START_R = 4;
    private MustacheEngine engine;

    public DefaultParser(MustacheEngine engine) {
        this.engine = engine;
    }

    @Override
    public void parse(String name, Reader reader, ParsingHandler handler) {
        if (name == null || reader == null || handler == null) {
            throw new NullPointerException();
        }
        reader = this.ensureBufferedReader(reader);
        Delimiters delimiters = new Delimiters(this.engine.getConfiguration().getStringPropertyValue(EngineConfigurationKey.START_DELIMITER), this.engine.getConfiguration().getStringPropertyValue(EngineConfigurationKey.END_DELIMITER));
        StringBuilder buffer = new StringBuilder();
        int state = 0;
        int delimiterIdx = 0;
        boolean triple = false;
        try {
            int val;
            handler.startTemplate(name, delimiters, this.engine);
            while ((val = reader.read()) != -1) {
                char character = (char)val;
                if (state == 1) {
                    if (character == delimiters.getStart(delimiterIdx)) {
                        if (delimiters.isStartOver(delimiterIdx)) {
                            state = 2;
                            delimiterIdx = 0;
                            buffer = this.flushText(buffer, handler);
                            continue;
                        }
                        ++delimiterIdx;
                        continue;
                    }
                    state = 0;
                    delimiterIdx = 0;
                    buffer.append(delimiters.getStartPart(delimiterIdx));
                    buffer.append(character);
                    continue;
                }
                if (state == 0) {
                    if (character == delimiters.getStart(0)) {
                        if (delimiters.isStartOver(delimiterIdx)) {
                            state = 2;
                            delimiterIdx = 0;
                            buffer = this.flushText(buffer, handler);
                            continue;
                        }
                        state = 1;
                        delimiterIdx = 1;
                        continue;
                    }
                    if (character == "\n".charAt(0)) {
                        state = 0;
                        buffer = this.flushText(buffer, handler);
                        this.flushLineSeparator("\n", handler);
                        continue;
                    }
                    if (character == "\r\n".charAt(0)) {
                        state = 4;
                        continue;
                    }
                    buffer.append(character);
                    continue;
                }
                if (state == 2) {
                    if (character == delimiters.getEnd(0)) {
                        if (triple) {
                            buffer.append(character);
                            triple = false;
                            continue;
                        }
                        if (delimiters.isEndOver(delimiterIdx)) {
                            state = 0;
                            delimiterIdx = 0;
                            buffer = this.flushTag(buffer, handler, delimiters);
                            continue;
                        }
                        state = 3;
                        delimiterIdx = 1;
                        continue;
                    }
                    if (character == delimiters.getStart(0)) {
                        triple = true;
                    }
                    buffer.append(character);
                    continue;
                }
                if (state == 3) {
                    if (character == delimiters.getEnd(delimiterIdx)) {
                        if (delimiters.isEndOver(delimiterIdx)) {
                            state = 0;
                            buffer = this.flushTag(buffer, handler, delimiters);
                            delimiterIdx = 0;
                            continue;
                        }
                        ++delimiterIdx;
                        continue;
                    }
                    throw new MustacheException(MustacheProblem.COMPILE_INVALID_TAG);
                }
                if (state == 4) {
                    if (character != "\r\n".charAt(1)) continue;
                    state = 0;
                    buffer = this.flushText(buffer, handler);
                    this.flushLineSeparator("\r\n", handler);
                    continue;
                }
                throw new IllegalStateException("Unknown parsing state");
            }
            if (buffer.length() > 0) {
                if (state == 0) {
                    this.flushText(buffer, handler);
                } else {
                    throw new MustacheException(MustacheProblem.COMPILE_INVALID_TEMPLATE, "Remaining non-text buffer: " + buffer);
                }
            }
            handler.endTemplate();
        }
        catch (IOException e) {
            throw new MustacheException(e);
        }
    }

    private StringBuilder flushText(StringBuilder buffer, ParsingHandler handler) {
        if (buffer.length() > 0) {
            handler.text(buffer.toString());
            return new StringBuilder();
        }
        return buffer;
    }

    private StringBuilder flushTag(StringBuilder buffer, ParsingHandler handler, Delimiters delimiters) {
        handler.tag(this.deriveTag(buffer.toString(), delimiters));
        return new StringBuilder();
    }

    private void flushLineSeparator(String separator, ParsingHandler handler) {
        handler.lineSeparator(separator);
    }

    private Reader ensureBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? reader : new BufferedReader(reader);
    }

    private ParsedTag deriveTag(String buffer, Delimiters delimiters) {
        if (buffer.length() <= 0) {
            throw new MustacheException(MustacheProblem.COMPILE_INVALID_TAG);
        }
        MustacheTagType type = MustacheTagType.fromBuffer(buffer, delimiters);
        String key = type.extractContent(buffer);
        return new ParsedTag(key, type);
    }
}

