/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.parser;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheTagType;
import org.trimou.engine.parser.Delimiters;
import org.trimou.engine.parser.ParsedTag;
import org.trimou.engine.parser.ParsingHandler;
import org.trimou.engine.segment.AbstractContainerSegment;
import org.trimou.engine.segment.CommentSegment;
import org.trimou.engine.segment.ExtendSectionSegment;
import org.trimou.engine.segment.ExtendSegment;
import org.trimou.engine.segment.InvertedSectionSegment;
import org.trimou.engine.segment.LineSeparatorSegment;
import org.trimou.engine.segment.PartialSegment;
import org.trimou.engine.segment.SectionSegment;
import org.trimou.engine.segment.Segment;
import org.trimou.engine.segment.SetDelimitersSegment;
import org.trimou.engine.segment.TemplateSegment;
import org.trimou.engine.segment.TextSegment;
import org.trimou.engine.segment.ValueSegment;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;

public class DefaultParsingHandler
implements ParsingHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultParsingHandler.class);
    private Deque<AbstractContainerSegment> containerStack = new ArrayDeque<AbstractContainerSegment>();
    private TemplateSegment template;
    private Delimiters delimiters;
    private long start;
    private long segments = 0L;

    @Override
    public void startTemplate(String name, Delimiters delimiters, MustacheEngine engine) {
        this.delimiters = delimiters;
        this.template = new TemplateSegment(name, engine);
        this.containerStack.addFirst(this.template);
        this.start = System.currentTimeMillis();
        logger.debug("Start compilation of {}", new Object[]{name});
    }

    @Override
    public void endTemplate() {
        this.validate();
        this.template.performPostProcessing();
        logger.debug("Compilation of {} finished [time: {} ms, segments: {}]", new Object[]{this.template.getText(), System.currentTimeMillis() - this.start, this.segments});
    }

    @Override
    public void text(String text) {
        this.addSegment(new TextSegment(text, this.template));
    }

    @Override
    public void tag(ParsedTag tag) {
        switch (tag.getType()) {
            case VARIABLE: {
                this.addSegment(new ValueSegment(tag.getContent(), this.template, false));
                break;
            }
            case UNESCAPE_VARIABLE: {
                this.addSegment(new ValueSegment(tag.getContent(), this.template, true));
                break;
            }
            case COMMENT: {
                this.addSegment(new CommentSegment(tag.getContent(), this.template));
                break;
            }
            case DELIMITER: {
                this.changeDelimiters(tag.getContent());
                this.addSegment(new SetDelimitersSegment(tag.getContent(), this.template));
                break;
            }
            case SECTION: {
                this.push(new SectionSegment(tag.getContent(), this.template));
                break;
            }
            case INVERTED_SECTION: {
                this.push(new InvertedSectionSegment(tag.getContent(), this.template));
                break;
            }
            case SECTION_END: {
                this.endSection(tag.getContent());
                break;
            }
            case PARTIAL: {
                this.addSegment(new PartialSegment(tag.getContent(), this.template));
                break;
            }
            case EXTEND: {
                this.push(new ExtendSegment(tag.getContent(), this.template));
                break;
            }
            case EXTEND_SECTION: {
                this.push(new ExtendSectionSegment(tag.getContent(), this.template));
                break;
            }
        }
    }

    @Override
    public void lineSeparator(String separator) {
        this.addSegment(new LineSeparatorSegment(separator, this.template));
    }

    public TemplateSegment getCompiledTemplate() {
        if (!this.template.isReadOnly()) {
            throw new MustacheException(MustacheProblem.TEMPLATE_NOT_READY);
        }
        return this.template;
    }

    private void endSection(String key) {
        AbstractContainerSegment container = this.pop();
        if (container == null || !key.equals(container.getText())) {
            throw new MustacheException(MustacheProblem.COMPILE_INVALID_SECTION_END);
        }
        this.addSegment(container);
    }

    private void changeDelimiters(String key) {
        if (key.charAt(0) != MustacheTagType.DELIMITER.getCommand().charValue() || key.charAt(key.length() - 1) != MustacheTagType.DELIMITER.getCommand().charValue()) {
            throw new MustacheException(MustacheProblem.COMPILE_INVALID_DELIMITERS);
        }
        Matcher matcher = Pattern.compile("([[^=]&&\\S]+)(\\s+)([[^=]&&\\S]+)").matcher(key.substring(1, key.length() - 1));
        if (!matcher.find()) {
            throw new MustacheException(MustacheProblem.COMPILE_INVALID_DELIMITERS);
        }
        this.delimiters.setNewValues(matcher.group(1), matcher.group(3));
    }

    private void push(AbstractContainerSegment container) {
        this.containerStack.addFirst(container);
        logger.trace("Push {} [name: {}]", (Object)container.getType(), (Object)container.getText());
    }

    private AbstractContainerSegment pop() {
        AbstractContainerSegment container = this.containerStack.removeFirst();
        logger.trace("Pop {} [name: {}]", (Object)container.getType(), (Object)container.getText());
        return container;
    }

    private void addSegment(Segment segment) {
        ++this.segments;
        this.containerStack.peekFirst().addSegment(segment);
        logger.trace("Add {}", (Object)segment);
    }

    private void validate() {
        if (!this.containerStack.peekFirst().equals(this.template)) {
            throw new MustacheException(MustacheProblem.COMPILE_INVALID_TEMPLATE, "Incorrect last container segment on the stack: " + this.containerStack.peekFirst().toString());
        }
    }
}

