/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver.i18n;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.SimpleConfigurationKey;
import org.trimou.engine.priority.Priorities;
import org.trimou.engine.resolver.ArrayIndexResolver;
import org.trimou.engine.resolver.i18n.LocaleAwareResolver;

public class DateTimeFormatResolver
extends LocaleAwareResolver {
    private static final Logger logger = LoggerFactory.getLogger(DateTimeFormatResolver.class);
    public static final int DATE_TIME_FORMAT_RESOLVER_PRIORITY = Priorities.after(ArrayIndexResolver.ARRAY_RESOLVER_PRIORITY);
    public static final ConfigurationKey CUSTOM_PATTERN_KEY = new SimpleConfigurationKey(DateTimeFormatResolver.class.getName() + ".customPattern", "M/d/yy h:mm a");
    private static final String NAME_FORMAT = "format";
    private static final String NAME_FORMAT_SHORT = "formatShort";
    private static final String NAME_FORMAT_CUSTOM = "formatCustom";
    private static final String NAME_FORMAT_DATE = "formatDate";
    private String customPattern;

    @Override
    public Object resolve(Object contextObject, String name) {
        if (contextObject == null) {
            return null;
        }
        Object formattableObject = this.getFormattableObject(contextObject);
        if (formattableObject == null) {
            return null;
        }
        if (NAME_FORMAT.equals(name)) {
            return this.format(2, formattableObject);
        }
        if (NAME_FORMAT_SHORT.equals(name)) {
            return this.format(3, formattableObject);
        }
        if (NAME_FORMAT_CUSTOM.equals(name)) {
            return this.formatCustom(formattableObject);
        }
        if (NAME_FORMAT_DATE.equals(name)) {
            return this.formatDate(2, formattableObject);
        }
        return null;
    }

    @Override
    public int getPriority() {
        return DATE_TIME_FORMAT_RESOLVER_PRIORITY;
    }

    @Override
    public void init(Configuration configuration) {
        super.init(configuration);
        this.customPattern = configuration.getStringPropertyValue(CUSTOM_PATTERN_KEY);
        logger.info("Initialized [customPattern: {}]", (Object)this.customPattern);
    }

    @Override
    public List<ConfigurationKey> getConfigurationKeys() {
        return Collections.singletonList(CUSTOM_PATTERN_KEY);
    }

    private Object getFormattableObject(Object contextObject) {
        if (contextObject instanceof Date || contextObject instanceof Number) {
            return contextObject;
        }
        if (contextObject instanceof Calendar) {
            return ((Calendar)contextObject).getTime();
        }
        return null;
    }

    private String format(int style, Object object) {
        return DateFormat.getDateTimeInstance(style, style, this.localeSupport.getCurrentLocale()).format(object);
    }

    private String formatDate(int style, Object object) {
        return DateFormat.getDateInstance(style, this.localeSupport.getCurrentLocale()).format(object);
    }

    private String formatCustom(Object object) {
        return new SimpleDateFormat(this.customPattern, this.localeSupport.getCurrentLocale()).format(object);
    }
}

