/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.segment.AbstractSegment;
import org.trimou.engine.segment.Segment;
import org.trimou.engine.segment.TemplateSegment;

public abstract class AbstractContainerSegment
extends AbstractSegment
implements Iterable<Segment> {
    protected List<Segment> segments = new ArrayList<Segment>();

    public AbstractContainerSegment(String name, TemplateSegment template) {
        super(name, template);
    }

    @Override
    public void execute(Appendable appendable, ExecutionContext context) {
        for (Segment segment : this.segments) {
            segment.execute(appendable, context);
        }
    }

    @Override
    public void performPostProcessing() {
        for (Segment segment : this.segments) {
            segment.performPostProcessing();
        }
    }

    public void addSegment(Segment segment) {
        this.checkModificationAllowed();
        this.segments.add(segment);
    }

    @Override
    public Iterator<Segment> iterator() {
        return this.getSegments().iterator();
    }

    public List<Segment> getSegments() {
        return this.isReadOnly() ? ImmutableList.copyOf(this.segments) : this.segments;
    }

    public int getSegmentsSize() {
        return this.segments.size();
    }

    protected String getContainingLiteralBlock() {
        StringBuilder literal = new StringBuilder();
        for (Segment segment : this.segments) {
            literal.append(segment.getLiteralBlock());
        }
        return literal.toString();
    }

    @Override
    protected String getSegmentName() {
        return this.getText();
    }
}

