/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.segment.AbstractSectionSegment;
import org.trimou.engine.segment.ExtendSectionSegment;
import org.trimou.engine.segment.Segment;
import org.trimou.engine.segment.SegmentType;
import org.trimou.engine.segment.TemplateSegment;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;

public class ExtendSegment
extends AbstractSectionSegment {
    public ExtendSegment(String text, TemplateSegment template) {
        super(text, template);
    }

    @Override
    public SegmentType getType() {
        return SegmentType.EXTEND;
    }

    @Override
    public void execute(Appendable appendable, ExecutionContext context) {
        TemplateSegment extended = (TemplateSegment)this.getEngine().getMustache(this.getText());
        if (extended == null) {
            throw new MustacheException(MustacheProblem.RENDER_INVALID_EXTEND_KEY);
        }
        for (Segment extendSection : this) {
            context.addDefiningSection(extendSection.getText(), (ExtendSectionSegment)extendSection);
        }
        extended.execute(appendable, context);
    }

    @Override
    public void addSegment(Segment segment) {
        if (!SegmentType.EXTEND_SECTION.equals((Object)segment.getType())) {
            return;
        }
        super.addSegment(segment);
    }
}

