/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.lang.reflect.Array;
import java.util.Iterator;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.segment.AbstractSectionSegment;
import org.trimou.engine.segment.SegmentType;
import org.trimou.engine.segment.TemplateSegment;

public class InvertedSectionSegment
extends AbstractSectionSegment {
    public InvertedSectionSegment(String text, TemplateSegment template) {
        super(text, template);
    }

    @Override
    public SegmentType getType() {
        return SegmentType.INVERTED_SECTION;
    }

    @Override
    public void execute(Appendable appendable, ExecutionContext context) {
        Object value = context.getValue(this.getText());
        boolean render = false;
        if (value == null) {
            render = true;
        } else if (value instanceof Boolean) {
            if (!((Boolean)value).booleanValue()) {
                render = true;
            }
        } else if (value instanceof Iterable) {
            Iterator iterator = ((Iterable)value).iterator();
            if (!iterator.hasNext()) {
                render = true;
            }
        } else if (value.getClass().isArray() && Array.getLength(value) == 0) {
            render = true;
        }
        if (render) {
            super.execute(appendable, context);
        }
    }
}

