/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.util.List;
import org.trimou.engine.MustacheTagType;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.segment.AbstractSegment;
import org.trimou.engine.segment.Segment;
import org.trimou.engine.segment.SegmentType;
import org.trimou.engine.segment.Segments;
import org.trimou.engine.segment.TemplateSegment;
import org.trimou.engine.segment.TextSegment;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;

public class PartialSegment
extends AbstractSegment {
    private String indentation;

    public PartialSegment(String text, TemplateSegment template) {
        super(text, template);
    }

    @Override
    public SegmentType getType() {
        return SegmentType.PARTIAL;
    }

    @Override
    public void execute(Appendable appendable, ExecutionContext context) {
        TemplateSegment partialTemplate = (TemplateSegment)this.getEngine().getMustache(this.getText());
        if (partialTemplate == null) {
            throw new MustacheException(MustacheProblem.RENDER_INVALID_PARTIAL_KEY);
        }
        if (this.indentation == null) {
            partialTemplate.execute(appendable, context);
        } else {
            List<List<Segment>> partialLines = Segments.readSegmentLinesBeforeRendering(partialTemplate);
            TextSegment indent = new TextSegment(this.indentation, this.getTemplate());
            for (List<Segment> line : partialLines) {
                line.add(0, indent);
            }
            for (List<Segment> line : partialLines) {
                for (Segment segment : line) {
                    segment.execute(appendable, context);
                }
            }
        }
    }

    @Override
    public String getLiteralBlock() {
        return this.getTagLiteral(MustacheTagType.PARTIAL.getCommand() + this.getText());
    }

    public void setIndentation(String indentation) {
        this.checkModificationAllowed();
        this.indentation = indentation;
    }
}

