/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.Iterator;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.segment.AbstractSectionSegment;
import org.trimou.engine.segment.IterationMeta;
import org.trimou.engine.segment.SegmentType;
import org.trimou.engine.segment.TemplateSegment;
import org.trimou.lambda.Lambda;

public class SectionSegment
extends AbstractSectionSegment {
    public SectionSegment(String text, TemplateSegment template) {
        super(text, template);
    }

    @Override
    public SegmentType getType() {
        return SegmentType.SECTION;
    }

    @Override
    public void execute(Appendable appendable, ExecutionContext context) {
        Object value = context.getValue(this.getText());
        if (value == null) {
            return;
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                super.execute(appendable, context);
            }
        } else if (value instanceof Iterable) {
            this.processIterable(appendable, context, value);
        } else if (value.getClass().isArray()) {
            this.processArray(appendable, context, value);
        } else if (value instanceof Lambda) {
            this.processLambda(appendable, context, value);
        } else {
            context.push(value);
            super.execute(appendable, context);
            context.pop();
        }
    }

    private void processIterable(Appendable appendable, ExecutionContext context, Object value) {
        Iterator iterator = ((Iterable)value).iterator();
        IterationMeta meta = new IterationMeta(iterator);
        context.push(meta);
        while (iterator.hasNext()) {
            context.push(iterator.next());
            super.execute(appendable, context);
            context.pop();
            meta.nextIteration();
        }
        context.pop();
    }

    private void processArray(Appendable appendable, ExecutionContext context, Object value) {
        int length = Array.getLength(value);
        IterationMeta meta = new IterationMeta(length);
        context.push(meta);
        for (int i = 0; i < length; ++i) {
            context.push(Array.get(value, i));
            super.execute(appendable, context);
            context.pop();
            meta.nextIteration();
        }
        context.pop();
    }

    private void processLambda(Appendable appendable, ExecutionContext context, Object value) {
        String input;
        Lambda lambda = (Lambda)value;
        switch (lambda.getInputType()) {
            case LITERAL: {
                input = this.getContainingLiteralBlock();
                break;
            }
            case PROCESSED: {
                StringWriter processed = new StringWriter();
                super.execute(processed, context);
                input = processed.toString();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        String returnValue = lambda.invoke(input);
        if (lambda.isReturnValueInterpolated()) {
            TemplateSegment temp = (TemplateSegment)this.getEngine().compileMustache(this.getTemplate().getName() + "_" + System.nanoTime(), returnValue);
            temp.execute(appendable, context);
        } else {
            this.append(appendable, returnValue);
        }
    }
}

