/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.segment.AbstractContainerSegment;
import org.trimou.engine.segment.PartialSegment;
import org.trimou.engine.segment.Segment;
import org.trimou.engine.segment.SegmentType;
import org.trimou.engine.segment.TemplateSegment;
import org.trimou.util.Strings;

public final class Segments {
    private static final Logger logger = LoggerFactory.getLogger(Segments.class);

    private Segments() {
    }

    static void removeStandaloneLines(TemplateSegment template) {
        List<List<Segment>> lines = Segments.readSegmentLines(template);
        HashSet<Segment> segmentsToRemove = new HashSet<Segment>();
        int idx = 0;
        for (List<Segment> line : lines) {
            ++idx;
            if (!Segments.isStandaloneLine(line)) continue;
            Segments.extractIndentationForPartial(line);
            for (Segment segment : line) {
                if (segment instanceof AbstractContainerSegment || SegmentType.PARTIAL.equals((Object)segment.getType())) continue;
                segmentsToRemove.add(segment);
            }
            logger.trace("Segment line {} is standalone", (Object)idx);
        }
        if (!segmentsToRemove.isEmpty()) {
            Segments.removeSegments(segmentsToRemove, template);
            logger.debug("{} segments removed", (Object)segmentsToRemove.size());
        }
    }

    static void extractIndentationForPartial(List<Segment> standaloneLine) {
        if (SegmentType.TEXT.equals((Object)standaloneLine.get(0).getType())) {
            PartialSegment partial = null;
            for (Segment segment : standaloneLine) {
                if (!SegmentType.PARTIAL.equals((Object)segment.getType())) continue;
                partial = (PartialSegment)segment;
                break;
            }
            if (partial != null) {
                partial.setIndentation(standaloneLine.get(0).getText());
            }
        }
    }

    static void removeUnnecessarySegments(AbstractContainerSegment container) {
        Iterator<Segment> iterator = container.iterator();
        while (iterator.hasNext()) {
            Segment segment = iterator.next();
            if (segment instanceof AbstractContainerSegment) {
                Segments.removeUnnecessarySegments((AbstractContainerSegment)segment);
                continue;
            }
            if (!SegmentType.COMMENT.equals((Object)segment.getType()) && !SegmentType.DELIMITERS.equals((Object)segment.getType())) continue;
            iterator.remove();
        }
    }

    static void removeSegments(Set<Segment> segmentsToRemove, AbstractContainerSegment container) {
        Iterator<Segment> iterator = container.iterator();
        while (iterator.hasNext()) {
            Segment segment = iterator.next();
            if (segment instanceof AbstractContainerSegment) {
                Segments.removeSegments(segmentsToRemove, (AbstractContainerSegment)segment);
                continue;
            }
            if (!segmentsToRemove.contains(segment)) continue;
            iterator.remove();
        }
    }

    static boolean isStandaloneLine(List<Segment> line) {
        boolean standaloneCandidate = false;
        for (Segment segment : line) {
            if (SegmentType.VALUE.equals((Object)segment.getType())) {
                return false;
            }
            if (SegmentType.TEXT.equals((Object)segment.getType())) {
                if (StringUtils.isWhitespace((CharSequence)segment.getText())) continue;
                return false;
            }
            if (!segment.getType().isStandaloneCandidate()) continue;
            standaloneCandidate = true;
        }
        return standaloneCandidate;
    }

    static List<List<Segment>> readSegmentLines(AbstractContainerSegment container) {
        ArrayList<List<Segment>> lines = new ArrayList<List<Segment>>();
        lines.add(Segments.readSegmentLines(lines, null, container));
        return lines;
    }

    static List<List<Segment>> readSegmentLinesBeforeRendering(AbstractContainerSegment container) {
        ArrayList<List<Segment>> lines = new ArrayList<List<Segment>>();
        ArrayList<Segment> currentLine = new ArrayList<Segment>();
        for (Segment segment : container) {
            if (!SegmentType.LINE_SEPARATOR.equals((Object)segment.getType())) {
                currentLine.add(segment);
                continue;
            }
            currentLine.add(segment);
            lines.add(currentLine);
            currentLine = new ArrayList();
        }
        if (!currentLine.isEmpty()) {
            lines.add(currentLine);
        }
        return lines;
    }

    static List<Segment> readSegmentLines(List<List<Segment>> lines, List<Segment> currentLine, AbstractContainerSegment container) {
        if (currentLine == null) {
            currentLine = new ArrayList<Segment>();
        }
        if (!SegmentType.TEMPLATE.equals((Object)container.getType())) {
            currentLine.add(container);
        }
        for (Segment segment : container) {
            if (segment instanceof AbstractContainerSegment) {
                currentLine = Segments.readSegmentLines(lines, currentLine, (AbstractContainerSegment)segment);
                continue;
            }
            if (!SegmentType.LINE_SEPARATOR.equals((Object)segment.getType())) {
                currentLine.add(segment);
                continue;
            }
            currentLine.add(segment);
            lines.add(currentLine);
            currentLine = new ArrayList<Segment>();
        }
        if (!SegmentType.TEMPLATE.equals((Object)container.getType())) {
            currentLine.add(container);
        }
        return currentLine;
    }

    public static String getSegmentTree(AbstractContainerSegment container) {
        return Segments.getSegmentTreeInternal(1, container);
    }

    private static String getSegmentTreeInternal(int level, AbstractContainerSegment container) {
        StringBuilder tree = new StringBuilder();
        tree.append(Strings.LINE_SEPARATOR);
        if (level > 1) {
            tree.append(StringUtils.repeat((String)" ", (int)(level - 1)));
        }
        tree.append("+");
        if (!SegmentType.TEMPLATE.equals((Object)container.getType())) {
            tree.append(container.getTemplate().getText());
            tree.append(":");
        }
        tree.append((Object)container.getType());
        tree.append(":");
        tree.append(container.getText());
        for (Segment segment : container.getSegments()) {
            if (segment instanceof AbstractContainerSegment) {
                tree.append(Segments.getSegmentTreeInternal(level + 1, (AbstractContainerSegment)segment));
                continue;
            }
            tree.append(Strings.LINE_SEPARATOR);
            tree.append(StringUtils.repeat((String)" ", (int)level));
            tree.append("-");
            tree.append(segment.getTemplate().getText());
            tree.append(":");
            tree.append((Object)segment.getType());
            if (!segment.getType().hasName()) continue;
            tree.append(":");
            tree.append(segment.getText());
        }
        return tree.toString();
    }
}

